﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <winext/cafe/mem/arena.h>
#include <winext/cafe/mem/defaultHeap.h>
#include <winext/cafe/mem/expHeap.h>
#include <cstdlib>
#include "heapCommoni.h"

namespace nw {
namespace internal {
namespace winext {

// Use all available MEM2 as default heap.  We will also refer to all of
// MEM2 as arena #2. The default heap is the expanded heap in MEM library.
#define DEFAULT_HEAP_ARENA     MEM_ARENA_2
#define DEFAULT_HEAP_ALIGNMENT 4

static MEMHeapHandle MEMdefaultHeap = MEM_HEAP_INVALID_HANDLE;

MEMHeapHandle MEMInitDefaultHeap (void* startAddress, u32 size) {
    MEMdefaultHeap = MEMCreateExpHeapEx(startAddress,
                                        size,
                                        MEM_HEAP_OPT_THREAD_SAFE);
    //ASSERT(MEM_HEAP_INVALID_HANDLE != MEMdefaultHeap);
    return MEMdefaultHeap;
}

void* MEMAllocFromDefaultHeap (u32 size) {
    return MEMAllocFromExpHeapEx(MEMdefaultHeap, size, PPC_IO_BUFFER_ALIGN);
}


void* MEMAllocFromDefaultHeapEx (u32 size, int alignment) {
    return MEMAllocFromExpHeapEx(MEMdefaultHeap, size, alignment);
}

void  MEMFreeToDefaultHeap (void* memBlock) {
    MEMFreeToExpHeap(MEMdefaultHeap, memBlock);
}

MEMHeapHandle MEMCreateUserHeapHandle(void* startAddress, u32 size)
{
    MEMiHeapHead* handle = (MEMiHeapHead*) startAddress;
    void* endAddress = (u8*) startAddress + size;

    MEMiInitHeapHead(handle, MEMi_USRHEAP_SIGNATURE,
        AddU32ToPtr(handle, sizeof(MEMiHeapHead)), endAddress, 0);

    return (MEMHeapHandle) handle;
}

//
// private APIs
//

/*---------------------------------------------------------------------------*
  Name:         _MEMGetDefaultHeapHandle

  Description:  Return the default heap handle.

  Arguments:    None

  Returns:      The default heap handle
 *---------------------------------------------------------------------------*/

MEMHeapHandle _MEMGetDefaultHeapHandle(void)
{
    return MEMdefaultHeap;
}

/*---------------------------------------------------------------------------*
  Name:         _MEMSetDefaultHeapHandle

  Description:  Set the specified heap to the default heap handle.

  Arguments:    A heap to be set to default heap handle.

  Returns:      None
 *---------------------------------------------------------------------------*/
void _MEMSetDefaultHeapHandle(MEMHeapHandle newDefaultHeap)
{
    MEMdefaultHeap = newDefaultHeap;
}

}
}
}
