﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __AX_UPSAMPLER_H__
#define __AX_UPSAMPLER_H__

#include <winext/cafe/ax.h>

namespace nw {
    namespace internal {
        namespace winext {

#define AX_UPSAMPLE_FILTER_LENGTH 66
#define AX_UPSAMPLE_OVERRATE	6
#define AX_UPSAMPLE_FILT_MEM_LENGTH ( AX_UPSAMPLE_FILTER_LENGTH / AX_UPSAMPLE_OVERRATE	)


    typedef struct {
        s32 filtMem[AX_MAX_NUM_TV_CHS][AX_UPSAMPLE_FILT_MEM_LENGTH];
        //s32 filtMem[AX_UPSAMPLE_FILT_MEM_LENGTH];
        u32 startIdx;		// starting index for this round of convolution
        u32 overRateSkip;	// how much oversampling we did
        u32 outIdxCount;
        u32 inIdxCount;
        u32 outIdxInc;
        u32 nextSampleIdx;
        u32 filtMemLength;
        u32 filterLength;
    }AXUpsampleStruct;

static void __AXUpsamplerInit(AXUpsampleStruct *upsampleStruct);


static u32 __AXUpsample32To48(s32 *input, s32 *output, AXUpsampleStruct *upSampleStruct, u32 numSamples, BOOL downshift, u32 numChs);

        } // namespace winext
    } // namespace internal
} // namespace nw

#endif // __AX_UPSAMPLER_H__
