﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include "AXHelper.h"

namespace nw {
namespace internal {
namespace winext {

AXPB_ERROR_CODE __AXCheckDeviceArgs(AXPBDeviceType device, u32 Id)
{
    AXPB_ERROR_CODE retErrCode = AXPB_ERROR_NONE;
     // Steps:
    // - Check for validity of the inputs
    // - in the switch code, set up max channels, pointers appropriately
    switch(device)
    {
        case AX_DEVICE_TV:
            // case of TV

            //ASSERT(Id < AX_MAX_NUM_TVS);

            if(Id >= AX_MAX_NUM_TVS)
            {
                retErrCode = AXPB_ERROR_DEVICE_ID;
                break;
            } // Id check

            break;  // end of case TV
        case AX_DEVICE_DRC:
            //ASSERT(Id < AX_MAX_NUM_DRCS);
            if(Id >= AX_MAX_NUM_DRCS)
            {
                retErrCode = AXPB_ERROR_DEVICE_ID;
                break;
            }
            break;  // end of case DRC
        case AX_DEVICE_RMT:
            //ASSERT(Id < AX_MAX_NUM_RMTS);
            if(Id >= AX_MAX_NUM_RMTS)
            {
                retErrCode = AXPB_ERROR_DEVICE_ID;
                break;
            }
            break;  // end of case RMT
        default:
            retErrCode = AXPB_ERROR_DEVICE_TYPE;
            break;
    } // end of switch(device)

    return retErrCode;
} // end of AXSetDeviceVolume

} // namespace winext
} // namespace internal
} // namespace nw
