﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include "SoundEngine.h"

#include <Windows.h>
#include <mmsystem.h>

namespace nw {
namespace internal {
namespace winext {

class CSoundEngineMME : public CSoundEngine
{
public:
    static CSoundEngineMME* Instance()
    {
        if ( sInstance == NULL ) { sInstance = new CSoundEngineMME; }
        return sInstance;
    }

    static void DestroyInstance()
    {
        if ( sInstance != NULL )
        {
            delete sInstance;
            sInstance = NULL;
        }
    }

    virtual BOOL IsActive() const;

    virtual BOOL OpenStream( UINT devideID );
    virtual void CloseStream();

    virtual unsigned long GetBufferLength()
    {
        return WAVE_BUF_SIZE;
    }

private:
    static const int SAMPLE_RATE = 48000;
#ifdef _DEBUG
    static const int WAVE_BUF_NUM = 64;
#else
    static const int WAVE_BUF_NUM = 24;
#endif
    static const int WAVE_BUF_NUM_FOR_VISTA = WAVE_BUF_NUM * 3;
    static const int WAVE_BUF_SAMPLES = 144;
    static const int WAVE_BUF_SIZE = WAVE_BUF_SAMPLES * 2 * CHANNEL_COUNT ;

    CSoundEngineMME();
    virtual ~CSoundEngineMME();

    static DWORD ThreadProcFunc( LPVOID pParam );
    DWORD ThreadProc();
    MMRESULT OnWaveOutDone( LPWAVEHDR waveHdr );

    BOOL SetupWaveOut();
    void ShutdownWaveOut();

    static CSoundEngineMME* sInstance;

    HANDLE m_hThread;
    DWORD m_ThreadID;

    HWAVEOUT m_hWaveOut;
    UINT m_DeviceID;
    WAVEFORMATEX m_WaveFormat;

    UINT m_nWaveBufferNum;
    LPWAVEHDR m_WaveHdr[ WAVE_BUF_NUM_FOR_VISTA ];
    LPSTR m_WaveBuffer[ WAVE_BUF_NUM_FOR_VISTA ];
};

} // namespace winext
} // namespace internal
} // namespace nw
