﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_INTERNAL_WINEXT_AUDIO_BUFFER_QUEUE_H_
#define NW_SND_INTERNAL_WINEXT_AUDIO_BUFFER_QUEUE_H_

#include <AudioUnit/AudioUnit.h>
#include <AudioToolbox/AudioToolbox.h>
#include <winext/types.h>
#include <mutex>
#include "SoundEngineCoreAudio.h"

namespace nw {
namespace internal {
namespace winext {

class AudioBufferQueue
{
public:
    AudioBufferQueue();
    ~AudioBufferQueue();
    AudioBuffer* Enqueue(u8* address, u32 size);
    AudioBuffer* Dequeue();
    AudioBuffer* Peek();
    uint32_t GetRemainBuffersCount();
private:
    static const int BuffersCount = CSoundEngineCoreAudio::BUFFER_COUNT;
    AudioBuffer m_AudioBufferQueue[BuffersCount];
    uint32_t m_EnqueuedBuffersCount;
    uint32_t m_DequeuedBuffersCount;
    std::mutex m_Mutex;
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

#endif /* NW_SND_INTERNAL_WINEXT_AUDIO_BUFFER_QUEUE_H_ */
