﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/ut/ut_LinkList.h>

namespace nw {
namespace ut {
namespace internal {

//--------------------------------------------------------------------------
LinkListImpl::iterator
LinkListImpl::erase(iterator it)
{
    NW_ASSERT(it.m_pPointer != &m_BaseNode);
    iterator itNext = it;
    (void)++itNext;
    return erase(it,itNext);
}


//--------------------------------------------------------------------------
LinkListImpl::iterator
LinkListImpl::erase(iterator itFirst,iterator itLast)
{
    Node* pIt = itFirst.m_pPointer;
    Node* const pItLast = itLast.m_pPointer;
    Node* pNext;

    for ( ; pIt != pItLast ; pIt = pNext)
    {
        pNext = pIt->m_pNext;
        (void)erase(pIt);
    }

    return itLast;
}

//--------------------------------------------------------------------------
void
LinkListImpl::reverse(void)
{
    if (empty()) { return; }

    Node* p = m_BaseNode.m_pNext;
    Node* pNext;

    Initialize_();

    for ( ; p != &m_BaseNode ; p = pNext )
    {
        pNext = p->m_pNext;
        p->m_pNext = NULL;
        p->m_pPrev = NULL;
        push_front(p);
    }
}

//--------------------------------------------------------------------------
LinkListImpl::iterator
LinkListImpl::insert(iterator it, pointer p)
{
    NW_ASSERT_NOT_NULL(p);
    Node *const pIt = it.m_pPointer;
    NW_ASSERT_NOT_NULL(pIt);

    Node *const pItPrev = pIt->m_pPrev;
    NW_ASSERT_NOT_NULL(pItPrev);

    NW_ASSERT(p->m_pNext == NULL);
    NW_ASSERT(p->m_pPrev == NULL);
    p->m_pNext = pIt;
    p->m_pPrev = pItPrev;

    pIt->m_pPrev = p;
    pItPrev->m_pNext = p;

    ++m_Size;
    return iterator(p);
}


//--------------------------------------------------------------------------
LinkListImpl::iterator
LinkListImpl::erase(pointer p)
{
    NW_ASSERT(!empty());
    NW_ASSERT_NOT_NULL(p);
    NW_ASSERT(p != &m_BaseNode);

    Node* const pNext = p->m_pNext;
    Node* const pPrev = p->m_pPrev;

    NW_ASSERT_NOT_NULL(pNext);
    pNext->m_pPrev = pPrev;
    NW_ASSERT_NOT_NULL(pPrev);
    pPrev->m_pNext = pNext;
    --m_Size;

    p->m_pNext = NULL;
    p->m_pPrev = NULL;

    return iterator(pNext);
}

}  // namespace internal
}  // namespace ut
}  // namespace nw
