﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/ut/os/ut_Time.h>
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
// TODO: NintendoSdk 対応後、このコメントを削除してください。
#include <windows.h>
#elif defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)
#include <time.h>
#endif

namespace nw {
namespace ut {

const s64 Tick::TICKS_PER_SECOND = Tick::GetFrequency();

//---------------------------------------------------------------------------
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
// TODO: NintendoSdk 対応後、このコメントを削除してください。
Tick
Tick::GetSystemCurrent()
{
    LARGE_INTEGER now;
    QueryPerformanceCounter( &now );
    return Tick( now.QuadPart );
}
#elif defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)
Tick
Tick::GetSystemCurrent()
{
    return Tick( clock() );
}
#endif

//---------------------------------------------------------------------------
s64
Tick::GetFrequency()
{
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    LARGE_INTEGER freq;
    BOOL ret = QueryPerformanceFrequency( &freq );
    if ( !ret )
    {
        NW_ERR( "QueryPerformanceFrequency failed.\n" );
        return 100000; // 適当な値.
    }
    return freq.QuadPart;
#elif defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)
    return CLOCKS_PER_SEC;
#else
    return OS_TIMER_CLOCK;
#endif
}

}  // namespace ut
}  // namespace nw
