﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#if defined( NW_PLATFORM_WIN32 ) || defined( NW_USE_NINTENDO_SDK )
// TODO: NintendoSdk 対応後、このコメントを削除してください。
#include <nw/types.h>

#include <nw/ut/os/ut_SpinLock.h>

#include <windows.h>
#endif

namespace nw {
namespace ut {

#if defined( NW_PLATFORM_WIN32 ) || defined( NW_USE_NINTENDO_SDK )
// TODO: NintendoSdk 対応後、このコメントを削除してください。

//---------------------------------------------------------------------------
void
SpinLock::Initialize()
{
    if (!m_IsIntialized)
    {
        NW_STATIC_ASSERT( sizeof(m_CriticalSection) >= sizeof(CRITICAL_SECTION) );
        m_IsIntialized = true;
        InitializeCriticalSection( reinterpret_cast<CRITICAL_SECTION*>(m_CriticalSection) );
    }
}

//---------------------------------------------------------------------------
void
SpinLock::Finalize()
{
    m_IsIntialized = false;
    DeleteCriticalSection(reinterpret_cast<CRITICAL_SECTION*>(m_CriticalSection));
}

//---------------------------------------------------------------------------
void
SpinLock::Lock()
{
    NW_ASSERT(m_IsIntialized);
    EnterCriticalSection( reinterpret_cast<CRITICAL_SECTION*>(m_CriticalSection) );
}

//---------------------------------------------------------------------------
bool
SpinLock::TryLock()
{
    NW_ASSERT(m_IsIntialized);
    return TryEnterCriticalSection( reinterpret_cast<CRITICAL_SECTION*>(m_CriticalSection) ) != 0;
}

//---------------------------------------------------------------------------
void
SpinLock::Unlock()
{
    NW_ASSERT(m_IsIntialized);
    LeaveCriticalSection( reinterpret_cast<CRITICAL_SECTION*>(m_CriticalSection) );
}

#endif

}  // namespace ut
}  // namespace nw
