﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/types.h>

#include <nw/ut/os/ut_Mutex.h>

#if defined(NW_PLATFORM_WIN32)
#include <windows.h>
#endif

namespace nw {
namespace ut {

#if defined( NW_PLATFORM_WIN32 ) || defined( NW_USE_NINTENDO_SDK )
// TODO: NintendoSdk 対応後、このコメントを削除してください。

//---------------------------------------------------------------------------
void
Mutex::Initialize()
{
    if (!m_IsIntialized)
    {
        NW_STATIC_ASSERT( sizeof(m_CriticalSection) >= sizeof(CRITICAL_SECTION) );
        m_IsIntialized = true;
        InitializeCriticalSection( reinterpret_cast<CRITICAL_SECTION*>(m_CriticalSection) );
    }
}

//---------------------------------------------------------------------------
void
Mutex::Finalize()
{
    m_IsIntialized = false;
    DeleteCriticalSection(reinterpret_cast<CRITICAL_SECTION*>(m_CriticalSection));
}

//---------------------------------------------------------------------------
void
Mutex::Lock()
{
    NW_ASSERT(m_IsIntialized);
    EnterCriticalSection( reinterpret_cast<CRITICAL_SECTION*>(m_CriticalSection) );
}

//---------------------------------------------------------------------------
bool
Mutex::TryLock()
{
    NW_ASSERT(m_IsIntialized);
    return TryEnterCriticalSection( reinterpret_cast<CRITICAL_SECTION*>(m_CriticalSection) ) != 0;
}

//---------------------------------------------------------------------------
void
Mutex::Unlock()
{
    NW_ASSERT(m_IsIntialized);
    LeaveCriticalSection( reinterpret_cast<CRITICAL_SECTION*>(m_CriticalSection) );
}

#elif defined( NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)

//---------------------------------------------------------------------------
void
Mutex::Initialize()
{
    if (!m_IsIntialized)
    {
        m_IsIntialized = true;
        m_CriticalSection = PTHREAD_RECURSIVE_MUTEX_INITIALIZER;
    }
}

//---------------------------------------------------------------------------
void
Mutex::Finalize()
{
    m_IsIntialized = false;
    const int result = pthread_mutex_destroy(&m_CriticalSection);
    NW_ASSERT(result >= 0);
    NW_UNUSED_VARIABLE(result);
}

//---------------------------------------------------------------------------
void
Mutex::Lock()
{
    NW_ASSERT(m_IsIntialized);
    const int result = pthread_mutex_lock(&m_CriticalSection);
    NW_ASSERT(result >= 0);
    NW_UNUSED_VARIABLE(result);
}

//---------------------------------------------------------------------------
bool
Mutex::TryLock()
{
    NW_ASSERT(m_IsIntialized);
    return pthread_mutex_trylock(&m_CriticalSection) == 0;
}

//---------------------------------------------------------------------------
void
Mutex::Unlock()
{
    NW_ASSERT(m_IsIntialized);
    int result = pthread_mutex_unlock(&m_CriticalSection);
    NW_ASSERT(result >= 0);
    NW_UNUSED_VARIABLE(result);
}

#endif

}  // namespace ut
}  // namespace nw
