﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/assert.h>
#include <nw/ut/os/ut_Event.h>

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
#include <windows.h>
#endif

namespace nw {
namespace ut {

Event::Event( bool manualReset, bool initialState )
{
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    m_Event = CreateEvent(NULL,manualReset,initialState,NULL);
#elif defined(NW_PLATFORM_CAFE)
    OSInitEvent(&m_Event,initialState,manualReset ? OS_EVENT_MANUAL : OS_EVENT_AUTO);
#elif defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)
    m_SignalState = initialState;
    m_ManualReset = manualReset;
    m_EventMutex = PTHREAD_MUTEX_INITIALIZER;
    m_EventCond = PTHREAD_COND_INITIALIZER;
#endif
}

Event::~Event()
{
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    CloseHandle(m_Event);
#elif defined(NW_PLATFORM_CAFE)
#elif defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)
    int result;

    result = pthread_mutex_destroy(&m_EventMutex);
    NW_ASSERT(result >= 0);
    result = pthread_cond_destroy(&m_EventCond);
    NW_ASSERT(result >= 0);
    NW_UNUSED_VARIABLE(result);
#endif
}

void Event::Signal()
{
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    SetEvent(m_Event);
#elif defined(NW_PLATFORM_CAFE)
    OSSignalEvent(&m_Event);
#elif defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)
    int result;
    result = pthread_mutex_lock(&m_EventMutex);
    NW_ASSERT(result >= 0);

    m_SignalState = true;
    if (m_ManualReset)
    {
        result = pthread_cond_broadcast(&m_EventCond);
    }
    else
    {
        result = pthread_cond_signal(&m_EventCond);
    }

    result = pthread_mutex_unlock(&m_EventMutex);
    NW_ASSERT(result >= 0);
    NW_UNUSED_VARIABLE(result);
#endif
}

void Event::Reset()
{
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    ResetEvent(m_Event);
#elif defined(NW_PLATFORM_CAFE)
    OSResetEvent(&m_Event);
#elif defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)
    int result;
    result = pthread_mutex_lock(&m_EventMutex);
    NW_ASSERT(result >= 0);

    m_SignalState = false;

    result = pthread_mutex_unlock(&m_EventMutex);
    NW_ASSERT(result >= 0);
    NW_UNUSED_VARIABLE(result);
#endif
}

void Event::Wait()
{
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    DWORD dwResult = WaitForSingleObject(m_Event,INFINITE);
    NW_ASSERT( dwResult == WAIT_OBJECT_0 );
#elif defined(NW_PLATFORM_CAFE)
    OSWaitEvent(&m_Event);
#elif defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)
    int result;
    result = pthread_mutex_lock(&m_EventMutex);
    NW_ASSERT(result >= 0);

    while (!m_SignalState)
    {
        pthread_cond_wait(&m_EventCond, &m_EventMutex);
    }

    // マニュアルリセットの場合はReset関数により任意のタイミングでフラグが下げられる
    if (!m_ManualReset)
    {
        m_SignalState = false;
    }

    result = pthread_mutex_unlock(&m_EventMutex);
    NW_ASSERT(result >= 0);
    NW_UNUSED_VARIABLE(result);
#endif
}

bool Event::TryWait()
{
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    DWORD dwResult = WaitForSingleObject(m_Event,0);
    return dwResult == WAIT_OBJECT_0;
#elif defined(NW_PLATFORM_CAFE)
    return OSWaitEventWithTimeout(&m_Event,0);
#elif defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)
    return m_SignalState;
#endif
}

} // namespace ut
} // namespace nw


