﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/mcs/mcs_Common.h>

#if defined( NW_PLATFORM_CAFE )
    #include <cafe/os/OSMessage.h>
    #include <cafe/os/OSAlarm.h>
#else
    #include <windows.h>
#endif

namespace
{

#if defined( NW_PLATFORM_CAFE )

    void
    SleepThreadAlarmHandler(
        OSAlarm*    alarm,
        OSContext*  /* context */
    )
    {
        OSMessage msg;
        msg.message = reinterpret_cast<void*>(1);

        // スレッドを起こすためにメッセージを書き込む
        OSMessageQueue *const pMsgQueue = static_cast<OSMessageQueue*>(OSGetAlarmUserData(alarm));
        BOOL bSuccess = OSSendMessage(pMsgQueue, &msg, OS_MESSAGE_NOBLOCK);
        NW_ASSERT(bSuccess);
    }

#endif

}   // namespace

namespace nw
{
namespace mcs
{
namespace internal
{

#if defined( NW_PLATFORM_CAFE )
    void
    SleepThread(u32 milSec)
    {
        OSAlarm alarm;
        OSCreateAlarm(&alarm);

        OSMessageQueue msgQueue;
        OSSetAlarmUserData(&alarm, &msgQueue);

        // サイズ1のメッセージキューを作成
        const int MsgNum = 1;
        OSMessage msgArray[MsgNum];
        OSInitMessageQueue(&msgQueue, msgArray, MsgNum);

        // 指定した時間にコールバックを呼ぶようにアラームをセット
        OSSetAlarm(&alarm, OSMillisecondsToTicks(milSec), SleepThreadAlarmHandler);

        // メッセージが書き込まれるまでブロックする
        OSMessage msg;
        BOOL bSuccess = OSReceiveMessage(&msgQueue, &msg, OS_MESSAGE_BLOCK);
        NW_ASSERT(bSuccess);

        OSCancelAlarm(&alarm);
    }

#else // #if defined(NW_PLATFORM_WIN32)

    void
    SleepThread(u32 milSec)
    {
        Sleep(milSec);
    }

#endif  // #if defined(NW_PLATFORM_WIN32)

}   // namespace internal
}   // namespace mcs
}   // namespace nw
