﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/gfnd/gfnd_Graphics.h>
#include <nw/gfnd/gfnd_GraphicsContext.h>
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
// TODO: NintendoSdk 対応後、このコメントを削除してください。
#include <Windows.h>
#endif

namespace nw
{
namespace gfnd
{

Graphics* Graphics::s_Instance = NULL;
Graphics::DefaultGraphicsLockObject Graphics::s_DefaultLockObj;

//------------------------------------------------------------------------------
void
Graphics::Initialize(nw::ut::ILockObject* lockObj)
{
    s_DefaultLockObj.Initialize();

    if (lockObj != NULL )
    {
        m_LockObj = lockObj;
    }

    LockDrawContext();
    {
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
        // TODO: NintendoSdk 対応後、このコメントを削除してください。

        // GraphicsGLでは、シザーテストは常に有効とする
        glEnable(GL_SCISSOR_TEST);
#else
        m_DepathCompareFunc = GX2_COMPARE_LEQUAL;
        m_BlendComblineColor = GX2_BLEND_COMBINE_ADD;
        m_BlendComblineAlpha = GX2_BLEND_COMBINE_ADD;
        m_BlendFunctionSrcColor = GX2_BLEND_SRC_ALPHA;
        m_BlendFunctionDstColor = GX2_BLEND_ONE_MINUS_SRC_ALPHA;
        m_BlendFunctionSrcAlpha = GX2_BLEND_SRC_ALPHA;
        m_BlendFunctionDstAlpha = GX2_BLEND_ONE_MINUS_SRC_ALPHA;
        m_StencilCompareFunc = GX2_COMPARE_LEQUAL;
        m_StencilStencilZPassFunction = GX2_STENCIL_KEEP;
        m_StencilStencilZFailFunction = GX2_STENCIL_KEEP;
        m_StencilStencilFailFunction = GX2_STENCIL_KEEP;
        m_AlphaCompareFunc = GX2_COMPARE_ALWAYS;
        m_AlphaTestRef = 0.f;
        m_ContextState = NULL;
        m_IsCullFront = GX2_DISABLE;
        m_IsCullBack = GX2_ENABLE;
        m_PolygonModeFront = GX2_POLYGON_MODE_TRIANGLE;
        m_PolygonModeBack = GX2_POLYGON_MODE_TRIANGLE;
        m_PolygonOffsetFrontEnable = GX2_FALSE;
        m_PolygonOffsetBackEnable = GX2_FALSE;
        m_PolygonOffsetPointLineEnable = GX2_FALSE;
#endif

        GraphicsContext context;
        context.Apply();
    }
    UnlockDrawContext();
}

//------------------------------------------------------------------------------
bool
Graphics::SetVBlankWaitInterval( u32 interval )
{
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    typedef BOOL (APIENTRY *PFNWGLSWAPINTERVALFARPROC)(BOOL isEnable);

    const PFNWGLSWAPINTERVALFARPROC wglSwapIntervalEXT =
        reinterpret_cast<PFNWGLSWAPINTERVALFARPROC>(wglGetProcAddress("wglSwapIntervalEXT"));

    if (wglSwapIntervalEXT)
    {
        wglSwapIntervalEXT( interval );
        return true;
    }
    return false;

#else
    NW_UNUSED_VARIABLE( interval );
    return false;
#endif
}

//------------------------------------------------------------------------------
void
Graphics::LockDrawContext()
{
    m_LockObj->Lock();
}

//------------------------------------------------------------------------------
void
Graphics::UnlockDrawContext()
{
    m_LockObj->Unlock();
}

//---------------------------------------------------------------------------
void
Graphics::DefaultGraphicsLockObject::Lock()
{
    m_Mutex.Lock();

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    BOOL b = wglMakeCurrent( reinterpret_cast<HDC>( m_HDC ), reinterpret_cast<HGLRC>( m_HGLRC ) );
    NW_ASSERT( b );
#else
#endif
}

//---------------------------------------------------------------------------
void
Graphics::DefaultGraphicsLockObject::Unlock()
{
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    glFinish();
    NW_GL_ASSERT();
    BOOL b = wglMakeCurrent( NULL, NULL );
    (void)b;
#else
#endif

    m_Mutex.Unlock();
}


} // namespace nw::gfnd
} // namespace nw
