﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dw/system/dw_UIRenderer.h>
#include <nw/dw/system/dw_IUIRenderContext.h>
#include <nw/dw/system/dw_DrawLineArgs.h>
#include <nw/dw/system/dw_DrawRectangleArgs.h>
#include <nw/dw/system/dw_DrawTextArgs.h>
#include <nw/dev/dev_PrimitiveRenderer.h>

namespace nw {
namespace internal {
namespace dw {

UIRenderer::UIRenderer() :
m_ProjectionMatrix(nw::math::Matrix44::Identity()),
m_ViewMatrix(nw::math::Matrix34::Identity()),
m_State(IDLE)
{
}

const nw::math::Matrix44& UIRenderer::GetProjectionMatrix() const
{
    return m_ProjectionMatrix;
}

const nw::math::Matrix34& UIRenderer::GetViewMatrix() const
{
    return m_ViewMatrix;
}

void UIRenderer::SetProjectionMatrix(const nw::math::Matrix44& matrix)
{
    m_ProjectionMatrix = matrix;
}

void UIRenderer::SetViewMatrix(const nw::math::Matrix34& matrix)
{
    m_ViewMatrix = matrix;
}

void UIRenderer::DrawLine(const DrawLineArgs& arg)
{
    if(!SetState(PRIMITIVE_RENDERING))
    {
        return;
    }

    DrawLineInternal(NULL, arg);
}

void UIRenderer::DrawLine(const IUIRenderContext* pRenderContext, const DrawLineArgs& arg)
{
    if(!SetState(PRIMITIVE_RENDERING))
    {
        return;
    }

    DrawLineInternal(pRenderContext, arg);
}

void UIRenderer::DrawLine(const IUIRenderContext* pRenderContext, const DrawMultiLineArgs& arg)
{
    if(!SetState(PRIMITIVE_RENDERING))
    {
        return;
    }

    DrawLineInternal(pRenderContext, arg);
}

void UIRenderer::DrawRectangle(const DrawRectangleArgs& arg)
{
    if(!SetState(PRIMITIVE_RENDERING))
    {
        return;
    }

    DrawRectangleInternal(NULL, arg);
}

void UIRenderer::DrawRectangle(const IUIRenderContext* pRenderContext, const DrawRectangleArgs& arg)
{
    if(!SetState(PRIMITIVE_RENDERING))
    {
        return;
    }

    DrawRectangleInternal(pRenderContext, arg);
}

void UIRenderer::FillRectangle(const DrawRectangleArgs& arg)
{
    if(!SetState(PRIMITIVE_RENDERING))
    {
        return;
    }

    FillRectangleInternal(NULL, arg);
}

void UIRenderer::FillRectangle(const IUIRenderContext* pRenderContext, const DrawRectangleArgs& arg)
{
    if(!SetState(PRIMITIVE_RENDERING))
    {
        return;
    }

    FillRectangleInternal(pRenderContext, arg);
}

void UIRenderer::DrawTexture(const DrawRectangleArgs& arg)
{
    if(!SetState(PRIMITIVE_RENDERING))
    {
        return;
    }

    DrawTextureInternal(NULL, arg);
}

void UIRenderer::DrawTexture(const IUIRenderContext* pRenderContext, const DrawRectangleArgs& arg)
{
    if(!SetState(PRIMITIVE_RENDERING))
    {
        return;
    }

    DrawTextureInternal(pRenderContext, arg);
}

void UIRenderer::DrawText(const DrawTextArgs& arg, const char* pText)
{
    if(!SetState(TEXT_WRITING))
    {
        return;
    }

    DrawTextInternal(NULL, arg, pText);
}

void UIRenderer::DrawText(const IUIRenderContext* pRenderContext, const DrawTextArgs& arg, const char* pText)
{
    if(!SetState(TEXT_WRITING))
    {
        return;
    }

    DrawTextInternal(pRenderContext, arg, pText);
}

void UIRenderer::DrawTextFormat(const DrawTextArgs& arg, const char* pFormat, ...)
{
    if(!SetState(TEXT_WRITING))
    {
        return;
    }

    va_list list;
    va_start(list, pFormat);

    DrawTextFormatInternal(NULL, arg, pFormat, list);

    va_end(list);
}

void UIRenderer::DrawTextFormat(const IUIRenderContext* pRenderContext, const DrawTextArgs& arg, const char* pFormat, ...)
{
    if(!SetState(TEXT_WRITING))
    {
        return;
    }

    va_list list;
    va_start(list, pFormat);

    DrawTextFormatInternal(pRenderContext, arg, pFormat, list);

    va_end(list);
}

nw::math::Vector2 UIRenderer::MeasureText(const DrawTextArgs& arg, const char* pText)
{
    return MeasureTextInternal(arg, pText);
}

nw::math::Vector2 UIRenderer::MeasureTextFormat(const DrawTextArgs& arg, const char* pFormat, ...)
{
    va_list list;
    va_start(list, pFormat);

    nw::math::Vector2 result = MeasureTextFormatInternal(arg, pFormat, list);

    va_end(list);

    return result;
}

UIRenderer::State UIRenderer::GetState() const
{
    return m_State;
}

bool UIRenderer::SetState(State state)
{
    if(m_State == state)
    {
        return true;
    }

    m_State = ChangeState(state);
    return m_State == state;
}

} // dw
} // internal
} // nw
