﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dw/system/dw_DrawTextArgs.h>

namespace nw {
namespace internal {
namespace dw {

DrawTextArgs::DrawTextArgs() :
topLeft(0.f, 0.f),
scale(1.f),
color(nw::ut::Color4f::WHITE())
{
}

DrawTextArgs& DrawTextArgs::SetTopLeft(float x, float y)
{
    topLeft.x = x;
    topLeft.y = y;
    return *this;
}

DrawTextArgs& DrawTextArgs::SetTopLeft(const nw::math::Vector2& value)
{
    topLeft = value;
    return *this;
}

DrawTextArgs& DrawTextArgs::SetScale(float value)
{
    scale = value;
    return *this;
}

DrawTextArgs& DrawTextArgs::SetColor(float r, float g, float b, float a)
{
    color.r = r;
    color.g = g;
    color.b = b;
    color.a = a;
    return *this;
}

DrawTextArgs& DrawTextArgs::SetColor(const nw::ut::Color4f& value)
{
    color = value;
    return *this;
}

DrawTextArgs& DrawTextArgs::Offset(float x, float y)
{
    topLeft.x += x;
    topLeft.y += y;
    return *this;
}

DrawTextArgs& DrawTextArgs::Offset(const nw::math::Vector2& value)
{
    topLeft += value;
    return *this;
}

} // dw
} // internal
} // nw
