﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dw/system/dw_DrawLineArgs.h>

namespace nw {
namespace internal {
namespace dw {

DrawLineArgs& DrawLineArgs::SetFrom(float x, float y)
{
    from.x = x;
    from.y = y;
    return *this;
}

DrawLineArgs& DrawLineArgs::SetFrom(const nw::math::Vector2& value)
{
    from = value;
    return *this;
}

DrawLineArgs& DrawLineArgs::SetTo(float x, float y)
{
    to.x = x;
    to.y = y;
    return *this;
}

DrawLineArgs& DrawLineArgs::SetTo(const nw::math::Vector2& value)
{
    to = value;
    return *this;
}

DrawLineArgs& DrawLineArgs::SetColor(const nw::ut::Color4f& value)
{
    color0 = value;
    color1 = value;
    return *this;
}

DrawLineArgs& DrawLineArgs::SetColor(const nw::ut::Color4f& col0, const nw::ut::Color4f& col1)
{
    this->color0 = col0;
    this->color1 = col1;
    return *this;
}

DrawLineArgs& DrawLineArgs::SetColor0(float r, float g, float b, float a)
{
    color0.r = r;
    color0.g = g;
    color0.b = b;
    color0.a = a;
    return *this;
}

DrawLineArgs& DrawLineArgs::SetColor0(const nw::ut::Color4f& value)
{
    color0 = value;
    return *this;
}

DrawLineArgs& DrawLineArgs::SetColor1(float r, float g, float b, float a)
{
    color1.r = r;
    color1.g = g;
    color1.b = b;
    color1.a = a;
    return *this;
}

DrawLineArgs& DrawLineArgs::SetColor1(const nw::ut::Color4f& value)
{
    color1 = value;
    return *this;
}

DrawLineArgs& DrawLineArgs::SetLineWidth(float width)
{
    lineWidth = width;
    return *this;
}

DrawLineArgs& DrawLineArgs::Offset(float x, float y)
{
    from.x += x;
    from.y += y;
    to.x += x;
    to.y += y;
    return *this;
}

DrawLineArgs& DrawLineArgs::Offset(const nw::math::Vector2& value)
{
    from += value;
    to += value;
    return *this;
}

DrawMultiLineArgs& DrawMultiLineArgs::SetColor(const nw::ut::Color4f& value)
{
    color = value;
    return *this;
}

DrawMultiLineArgs& DrawMultiLineArgs::SetLineWidth(float width)
{
    lineWidth = width;
    return *this;
}

} // dw
} // internal
} // nw
