﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dw/control/dw_UIElementRenderArgs.h>

namespace nw {
namespace internal {
namespace dw {

UIElementRenderArgs& UIElementRenderArgs::SetIsBordered(bool value)
{
    isBordered = value;
    return *this;
}

UIElementRenderArgs& UIElementRenderArgs::SetBorderColor(const nw::ut::Color4f& value)
{
    borderColor = value;
    return *this;
}

UIElementRenderArgs& UIElementRenderArgs::SetBackgroundColor(const nw::ut::Color4f& value)
{
    backgroundColor0 = value;
    backgroundColor1 = value;
    return *this;
}

UIElementRenderArgs& UIElementRenderArgs::SetBackgroundColor(const nw::ut::Color4f& value0, const nw::ut::Color4f& value1)
{
    backgroundColor0 = value0;
    backgroundColor1 = value1;
    return *this;
}

} // dw
} // internal
} // nw
