﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dw/control/dw_UIElementAligner.h>

namespace nw {
namespace internal {
namespace dw {

nw::ut::Rect UIElementAligner::GetHorizontalAlignedRect(UIElement& element, f32 x, f32 width)
{
    nw::ut::Rect result;
    nw::math::Vector2 thisSize   = element.GetMeasuredSize();
    Thickness         thisMargin = element.GetMargin();

    switch(element.GetHorizontalAlignment())
    {
    case HORIZONTAL_STRETCH:
        result.left = x + thisMargin.left;
        result.SetWidth(width - thisMargin.GetWidth());
        break;

    case HORIZONTAL_LEFT:
        result.left = x + thisMargin.left;
        result.SetWidth(thisSize.x);
        break;

    case HORIZONTAL_RIGHT:
        result.left = x + width - thisSize.x - thisMargin.right;
        result.SetWidth(thisSize.x);
        break;

    case HORIZONTAL_CENTER:
        result.left = x + thisMargin.left + (width - thisSize.x - thisMargin.GetWidth()) / 2;
        result.SetWidth(thisSize.x);
        break;
    }

    return result;
}

nw::ut::Rect UIElementAligner::GetVerticalAlignedRect(UIElement& element, f32 y, f32 height)
{
    nw::ut::Rect result;
    nw::math::Vector2 thisSize   = element.GetMeasuredSize();
    Thickness         thisMargin = element.GetMargin();

    switch(element.GetVerticalAlignment())
    {
    case VERTICAL_STRETCH:
        result.top = y + thisMargin.top;
        result.SetHeight(height - thisMargin.GetHeight());
        break;

    case VERTICAL_TOP:
        result.top = y + thisMargin.top;
        result.SetHeight(thisSize.y);
        break;

    case VERTICAL_BOTTOM:
        result.top = y + height - thisSize.y - thisMargin.bottom;
        result.SetHeight(thisSize.y);
        break;

    case VERTICAL_CENTER:
        result.top = y + thisMargin.top + (height - thisSize.y - thisMargin.GetHeight()) / 2;
        result.SetHeight(thisSize.y);
        break;
    }

    return result;
}

} // dw
} // internal
} // nw
