﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dw/control/dw_Canvas.h>

namespace nw {
namespace internal {
namespace dw {

Canvas::Canvas()
{
}

const nw::math::Vector2 Canvas::OnMeasure(UIRenderer& renderer) const
{
    (void)renderer;

    UIElementList& contents = GetContents();

    f32 x = 0.f;
    f32 y = 0.f;

    for(int i=0; i<contents.GetCount(); ++i)
    {
        UIElement* pContent = contents[i];

        if(pContent == NULL ||
            pContent->GetVisibility() == COLLAPSED)
        {
            continue;
        }

        const nw::math::Vector2 size = pContent->GetMeasuredSize();

        if(size.IsZero())
        {
            continue;
        }

        const nw::math::Vector2 topLeft = pContent->GetTopLeft();
        const Thickness margin = pContent->GetMargin();

        x = nw::ut::Max(x, topLeft.x + size.x + margin.right);
        y = nw::ut::Max(y, topLeft.y + size.y + margin.bottom);
    }

    return nw::math::Vector2(x, y);
}

} // dw
} // internal
} // nw
