__NW_TO_TEXT( 
/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

uniform mat4 wvp;
uniform mat4 user;
uniform vec4 color0;
uniform vec4 color1;
uniform vec2 uv_src;
uniform vec2 uv_size;

attribute vec3 Vertex;
attribute vec2 TexCoord0;
attribute vec4 ColorRate;


void main(void)
{
    gl_Position     = vec4( Vertex,1 ) * user * wvp;
    gl_FrontColor   = color0 * ( 1.0 - ColorRate.r ) + color1 * ColorRate.r;
    gl_TexCoord[0]  = vec4( TexCoord0 * uv_size + uv_src, 0, 1 );
}
) 
