﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dev/dev_FsFileLogger.h>
#include <nw/assert.h>

#if defined( NW_PLATFORM_WIN32 ) || defined( NW_USE_NINTENDO_SDK )
// TODO: NintendoSdk 対応後、このコメントを削除してください。
  using namespace nw::internal::winext;
#endif

namespace nw
{
namespace dev
{

bool FsFileLogger::Open(FSClient* fsClient, FSCmdBlock* fsCmdBlock, const char* filePath)
{
    NW_NULL_ASSERT(filePath);

    if(!m_FileStream.Open(fsClient, fsCmdBlock, filePath, "a+"))
    {
        return false;
    }

    if(GetBufferSize() == 0)
    {
        SetBuffer(m_DefaultBuffer0, m_DefaultBuffer1, DEFAULT_BUFFER_SIZE);
    }

    Attach(m_FileStream);

    return IsAttached();
}

} // namespace dev
} // namespace nw

