﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dev/cafe/dev_PadCafe.h>
#include <nw/dev/dev_PadUtil.h>

#if defined(NW_DEV_PAD_ENABLE)

namespace nw
{
namespace dev
{

//------------------------------------------------------------------------------
PadCafe::PadCafe(s32 channel)
: Pad(),
  m_Channel( channel ),
  m_IsConnected( false ),
  m_PadDevice( NULL )
{
}

//------------------------------------------------------------------------------
void
PadCafe::GetPadStatus( PADStatus* pad )
{
    if ( m_PadStatus )
    {
        *pad = m_PadStatus->padStatuses[ m_Channel ];
    }
    else
    {
        *pad = m_PadDevice->GetPadStatus( m_Channel );
    }
}

//------------------------------------------------------------------------------
void
PadCafe::UpdateImpl()
{
    const PADStatus* padStatus;

    if ( m_PadStatus )
    {
        padStatus = &m_PadStatus->padStatuses[ m_Channel ];
    }
    else if ( m_PadDevice )
    {
        padStatus = &m_PadDevice->GetPadStatus( m_Channel );
    }
    else
    {
        return;
    }

    if ( padStatus->err == PAD_ERR_NONE )
    {
        u32 padHold = padStatus->button;

        // Holdの値を設定
        m_PadHold.SetAllZero();
        m_PadHold.ChangeMask(MASK_A, padHold & PAD_BUTTON_A);
        m_PadHold.ChangeMask(MASK_B, padHold & PAD_BUTTON_B);
        m_PadHold.ChangeMask(MASK_X, padHold & PAD_BUTTON_X);
        m_PadHold.ChangeMask(MASK_Y, padHold & PAD_BUTTON_Y);
        m_PadHold.ChangeMask(MASK_R, padHold & PAD_TRIGGER_R);
        m_PadHold.ChangeMask(MASK_L, padHold & PAD_TRIGGER_L);
        m_PadHold.ChangeMask(MASK_Z, padHold & PAD_TRIGGER_Z);
        m_PadHold.ChangeMask(MASK_START, padHold & PAD_BUTTON_START);
        m_PadHold.ChangeMask(MASK_RIGHT, padHold & PAD_BUTTON_RIGHT);
        m_PadHold.ChangeMask(MASK_LEFT, padHold & PAD_BUTTON_LEFT);
        m_PadHold.ChangeMask(MASK_UP, padHold & PAD_BUTTON_UP);
        m_PadHold.ChangeMask(MASK_DOWN, padHold & PAD_BUTTON_DOWN);

        // アナログスティックを設定
        detail::NormalizeStickValueCafe( &m_LeftStick, padStatus->stickX, padStatus->stickY );
        detail::NormalizeStickValueCafe( &m_RightStick, padStatus->substickX, padStatus->substickY) ;

        m_LeftAnalogTrigger = padStatus->triggerLeft;
        m_RightAnalogTrigger = padStatus->triggerRight;

        m_IsConnected = true;
    }
    else
    {
        m_IsConnected = false;
    }
}

} // namespace dev
} // namespace nw

#endif // NW_DEV_PAD_ENABLE
