﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dev/cafe/dev_KeyboardMouseDeviceCafe.h>

#if defined(NW_DEV_PAD_ENABLE)

namespace nw
{
namespace dev
{

KeyboardMouseDeviceCafe* KeyboardMouseDeviceCafe::s_pInstance = NULL;

//------------------------------------------------------------------------------
KeyboardMouseDeviceCafe::KeyboardMouseDeviceCafe()
 : m_IsAvailable( false ),
   m_PadRepeatDelays( PAD_REPEAT_DELAY_DEFAULT ),
   m_PadRepeatPulses( PAD_REPEAT_PULSE_DEFAULT )
{
    if (s_pInstance != NULL)
    {
        NW_FATAL_ERROR("nw::dev::KeyboardMouseDeviceCafe instance already exists.");
    }
    s_pInstance = this;

    for ( int i = 0; i < V_KEY_MAX; i++ )
    {
        m_PadHoldCounts[i] = 0;
    }
}

//------------------------------------------------------------------------------
void
KeyboardMouseDeviceCafe::Initialize()
{
    if ( nw::mcs::McsHID_IsInitialized() )
    {
        nw::mcs::McsHID_RegisterEventHandler(&m_InputEventHandler);
    }
}

//------------------------------------------------------------------------------
void
KeyboardMouseDeviceCafe::Update()
{
    // イベント発生フラグをリセットします。
    m_InputEventHandler.ResetEvent();

    if ( nw::mcs::McsHID_IsInitialized() && nw::mcs::MCS_ERROR_SUCCESS == nw::mcs::McsHID_Polling() )
    {
        m_IsAvailable = true;

        for ( int i = 0; i < V_KEY_MAX; ++i )
        {
            m_VkeyTrig[ i ] = ( m_VkeyHold[ i ] == V_KEY_OFF && m_InputEventHandler.GetKeyStatus( i ) ) ? V_KEY_ON : V_KEY_OFF;
            m_VkeyHold[ i ] = m_InputEventHandler.GetKeyStatus( i );
            m_VkeyRepeat[ i ] = V_KEY_OFF;

            if ( m_VkeyHold[ i ] == V_KEY_ON )
            {
                // リピートを更新
                if ( m_PadRepeatPulses > 0 )
                {
                    if ( m_PadHoldCounts[ i ] == m_PadRepeatDelays )
                    {
                        m_VkeyRepeat[ i ] = V_KEY_ON;
                    }
                    else if ( m_PadRepeatDelays < m_PadHoldCounts[ i ] )
                    {
                        if ( ( m_PadHoldCounts[ i ] - m_PadRepeatDelays ) % m_PadRepeatPulses == 0 )
                        {
                            m_VkeyRepeat[ i ] = V_KEY_ON;
                        }
                    }
                }

                m_PadHoldCounts[ i ] += 1;
            }
            else
            {
                m_PadHoldCounts[ i ] = 0;
            }
        }
    }
    else
    {
        m_IsAvailable = false;
    }
}

//------------------------------------------------------------------------------
void
KeyboardMouseDeviceCafe::SetKeyRepeat(u8 delayFrame, u8 pulseFrame)
{
    m_PadRepeatDelays = delayFrame;
    m_PadRepeatPulses = pulseFrame;
}

} // namespace dev
} // namespace nw

#endif // NW_DEV_PAD_ENABLE
