﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../precompiled.h"

#ifdef NW_SND_SPY_ENABLE

#include <nw/snd/spy/sndspy_SpyData.h>

namespace nw {
namespace snd {
namespace spy {

//----------------------------------------------------------
void PString::Assign( const char* str )
{
    const char* srcp = str;

    u32 labelLength = std::strlen(str);
    if ( labelLength > 0xff ) labelLength = 0xff;
    u32 itemSize = sizeof(u8) + labelLength;
    u32 paddingSize = (~( itemSize + 0x03 )) & 0x03;
    len = static_cast<u8>(labelLength);
    char* destp = this->str;
    char* endp = destp + labelLength;
    while( destp != endp )
    {
        *destp++ = *srcp++;
    }
    endp = destp + paddingSize;
    while( destp != endp )
    {
        *destp++ = '\0';
    }
}

} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_SPY_ENABLE
