﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#ifdef NW_SND_SPY_ENABLE

#include <nw/snd/spy/sndspy_SpyController.h>
#include <nw/snd/spy/fnd/string/sndspyfnd_String.h>
#include <nw/snd/spy/modules/sndspy_MarkerModule.h>

// NN_TEXT() マクロにより日本語を埋め込めるようになるまで、C4566 を無効化
#if defined(NW_PLATFORM_WIN32)
#pragma warning( disable : 4566 )
#endif

namespace nw {
namespace snd {
namespace spy {

//----------------------------------------------------------
MarkerModule::MarkerModule()
    : SpySimpleModule("Marker", MarkerPacket::PACKET_VERSION)
    , m_MarkerTop(NULL)
    , m_MarkerLast(NULL)
{
}

//----------------------------------------------------------
bool MarkerModule::AttachMarker(Marker& marker)
{
    if(marker.IsAttached())
    {
        if (marker.GetModule() != this)
        {
            NW_WARNING(false, "Marker は、複数の MarkerModule にアタッチできません。");
            return false;
        }

        return true;
    }

    if(m_MarkerTop == NULL)
    {
        m_MarkerTop = &marker;
        m_MarkerLast = &marker;
    }
    else
    {
        NW_ASSERT(m_MarkerLast != NULL);
        m_MarkerLast->SetNext(&marker);
        marker.SetPrev(m_MarkerLast);
        m_MarkerLast = &marker;
    }

    marker.Attach(*this);

    return true;
}

//----------------------------------------------------------
void MarkerModule::DetachMarker(Marker& marker)
{
    // Prev -> Next をつなぐ
    // Top を更新する
    if(marker.GetPrev() != NULL)
    {
        marker.GetPrev()->SetNext(marker.GetNext());
    }
    else
    {
        NW_ASSERT(m_MarkerTop == &marker);
        m_MarkerTop = marker.GetNext();
    }

    // Prev <- Next をつなぐ
    // Last を更新する
    if(marker.GetNext() != NULL)
    {
        marker.GetNext()->SetPrev(marker.GetPrev());
    }
    else
    {
        NW_ASSERT(m_MarkerLast == &marker);
        m_MarkerLast = marker.GetPrev();
    }

    marker.Detach();
}

//------------------------------------------------------------------------------
Marker::Marker()
    : m_Module(NULL)
    , m_Prev(NULL)
    , m_Next(NULL)
{
    InitializePacketCommonData();
}

//------------------------------------------------------------------------------
Marker::~Marker()
{
    if(IsAttached())
    {
        m_Module->DetachMarker(*this);
    }
}

//------------------------------------------------------------------------------
void Marker::PushValue(const char* description, u8 r, u8 g, u8 b)
{
    if(!IsRequested()) { return; }

    m_ValuePacketPayload.color.r = r;
    m_ValuePacketPayload.color.g = g;
    m_ValuePacketPayload.color.b = b;
    m_ValuePacketPayload.color.a = 0xFF;
    m_ValuePacketPayload.description.Set(description);

    m_Module->GetController()->PushData(*m_Module, &m_ValuePacketPayload, sizeof(MarkerPacket::ValuePacketPayload));
}

//------------------------------------------------------------------------------
void Marker::InitializePacketCommonData()
{
    m_ValuePacketPayload.id = reinterpret_cast<u32>(this);
}

//------------------------------------------------------------------------------
void Marker::Attach(MarkerModule& module)
{
    NW_ASSERTMSG(m_Module == NULL || m_Module == &module, "この Marker は、すでに他の MarkerModule にアタッチされています。");

    m_Module = &module;
}

//------------------------------------------------------------------------------
void Marker::Detach()
{
    m_Module = NULL;
    SetPrev(NULL);
    SetNext(NULL);
}

} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_SPY_ENABLE
