﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../../precompiled.h"

#include <nw/snd/spy/fnd/string/sndspyfnd_String.h>

namespace nw {
namespace snd {
namespace spy {
namespace internal {
namespace fnd {

//----------------------------------------------------------
void
String::Copy(char* buffer, u32 bufferLength, const char* src)
{
    NW_ASSERT_NOT_NULL(buffer);
    NW_ASSERT_NOT_NULL(src);

    // コピーバッファ競合チェック
    NW_ASSERT(buffer >= src || static_cast<u32>(GetOffsetFromPtr(buffer, src)) >= bufferLength);
    NW_ASSERT(buffer <= src || static_cast<u32>(GetOffsetFromPtr(src, buffer)) >= bufferLength);

    if(bufferLength == 0)
    {
        return;
    }

    const char* srcCurrent = src;
    char*       destCurrent = buffer;
    char*       destEnd = buffer + bufferLength;

    while(destCurrent + 1 != destEnd)
    {
        if(*srcCurrent == '\0')
        {
            break;
        }

        *destCurrent = *srcCurrent;

        ++srcCurrent;
        ++destCurrent;
    }

    // 終端文字を付加する
    *destCurrent = '\0';
}

} // namespace nw::snd::spy::internal::fnd
} // namespace nw::snd::spy::internal
} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw
