﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../../precompiled.h"

#include <nw/snd/spy/fnd/string/sndspyfnd_String.h>
#include <nw/snd/spy/fnd/string/sndspyfnd_FixedString.h>

namespace nw {
namespace snd {
namespace spy {
namespace internal {
namespace fnd {

//----------------------------------------------------------
FixedString::FixedString() :
m_Buffer(NULL),
m_BufferLength(0)
{
}

//----------------------------------------------------------
FixedString::FixedString(char* buffer, u32 bufferLength) :
m_Buffer(buffer),
m_BufferLength(bufferLength)
{
    NW_ASSERT((buffer == NULL) == (bufferLength == 0));
}

//----------------------------------------------------------
void
FixedString::Attach(char* buffer, u32 bufferLength)
{
    NW_ASSERT_NOT_NULL(buffer);
    NW_ASSERT(bufferLength > 0);
    NW_ASSERTMSG(!IsAttached(), "FixedString is already attached.\n");

    m_BufferLength = bufferLength;
    m_Buffer = buffer;

    // 終端文字を設定します。
    m_Buffer[m_BufferLength - 1] = '\0';
}

//----------------------------------------------------------
void
FixedString::Detach()
{
    m_BufferLength = 0;
    m_Buffer = NULL;
}

//----------------------------------------------------------
void
FixedString::CopyFrom(const char* value, u32 destIndex/*= 0*/)
{
    String::Copy(m_Buffer + destIndex, m_BufferLength - destIndex, value);
}

} // namespace nw::snd::spy::internal::fnd
} // namespace nw::snd::spy::internal
} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw
