﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../../../precompiled.h"

#include <nw/snd/spy/fnd/os/sndspyfnd_CriticalSection.h>

#include <Windows.h>

namespace nw {
namespace snd {
namespace spy {
namespace internal {
namespace fnd {

//---------------------------------------------------------------------------
CriticalSection::CriticalSection() :
m_IsInitialized(false)
{
    Initialize();
}

//---------------------------------------------------------------------------
CriticalSection::~CriticalSection()
{
    Finalize();
}

//---------------------------------------------------------------------------
void
CriticalSection::Initialize()
{
    if(m_IsInitialized)
    {
        return;
    }

    ::InitializeCriticalSection(reinterpret_cast<CRITICAL_SECTION*>(m_CriticalSection));
    m_IsInitialized = true;
}

//---------------------------------------------------------------------------
void
CriticalSection::Finalize()
{
    if(!m_IsInitialized)
    {
        return;
    }

    m_IsInitialized = false;
    ::DeleteCriticalSection(reinterpret_cast<CRITICAL_SECTION*>(m_CriticalSection));
}

//---------------------------------------------------------------------------
void
CriticalSection::Enter()
{
    NW_ASSERT(m_IsInitialized);
    ::EnterCriticalSection(reinterpret_cast<CRITICAL_SECTION*>(m_CriticalSection));
}

//---------------------------------------------------------------------------
bool
CriticalSection::TryEnter()
{
    NW_ASSERT(m_IsInitialized);
    return ::TryEnterCriticalSection(reinterpret_cast<CRITICAL_SECTION*>(m_CriticalSection)) == TRUE;
}

//---------------------------------------------------------------------------
void
CriticalSection::Leave()
{
    NW_ASSERT(m_IsInitialized);
    ::LeaveCriticalSection(reinterpret_cast<CRITICAL_SECTION*>(m_CriticalSection));
}

} // namespace nw::snd::spy::internal::fnd
} // namespace nw::snd::spy::internal
} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw
