﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/edit/util/sndedit_UpdateCachesHelper.h>

#ifdef NW_SND_CONFIG_ENABLE_DEV

namespace nw {
namespace snd {
namespace edit {

//----------------------------------------------------------
UpdateCachesHelper::UpdateCachesHelper() :
m_SoundArchiveEditor(NULL),
m_IsExitThread(false)
{
    m_ThreadMainDelegate.Initialize(this, &UpdateCachesHelper::ThreadMain);
}

//----------------------------------------------------------
Result
UpdateCachesHelper::Start(
    SoundArchiveEditor* soundArchiveEditor,
    void* threadStack,
    u32 threadStackSize,
    AFFINITY_MASK affinityMask /*= CORE_DEFAULT*/,
    u32 priority /*= snd::internal::fnd::Thread::DEFAULT_THREAD_PRIORITY*/)
{
    NW_ASSERT_NOT_NULL(soundArchiveEditor);
    NW_ASSERT_NOT_NULL(threadStack);
    NW_ASSERT(threadStackSize > 0);

    if(m_Thread.GetState() == snd::internal::fnd::Thread::STATE_RUNNING)
    {
        return Result(SNDEDIT_RESULT_FALSE);
    }

    m_IsExitThread = false;

    m_SoundArchiveEditor = soundArchiveEditor;
    m_UpdateCachesCanceller.Reset(NULL);

    snd::internal::fnd::Thread::RunArgs args;
    args.name = "nw::snd::edit::UpdateCachesHelper::Thread";
    args.stack = threadStack;
    args.stackSize = threadStackSize;
    args.affinityMask = static_cast<snd::internal::fnd::Thread::AFFINITY_MASK>(affinityMask);
    args.priority = priority;
    args.handler = &m_ThreadMainDelegate;

    if(!m_Thread.Run(args))
    {
        Stop();
        return Result(SNDEDIT_RESULT_FAILED);
    }

    return Result(SNDEDIT_RESULT_TRUE);
}

//----------------------------------------------------------
void
UpdateCachesHelper::Stop()
{
    m_IsExitThread = true;
    m_UpdateCachesCanceller.Cancel();

    m_Thread.WaitForExit();
    m_Thread.Release();

    m_SoundArchiveEditor = NULL;
}

//----------------------------------------------------------
u32
UpdateCachesHelper::ThreadMain(void* parameter)
{
    (void)parameter;
    while(!m_IsExitThread)
    {
        m_SoundArchiveEditor->UpdateCaches(&m_UpdateCachesCanceller);

        snd::internal::fnd::Thread::Sleep(
            snd::internal::fnd::TimeSpan::FromMilliSeconds(200)
            );
    }

    return 0;
}

} // namespace nw::snd::edit
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV
