﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/edit/hio/sndedit_HioSyncChannel.h>

#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <limits.h>
#include <nw/snd/edit/hio/sndedit_HioManager.h>
#include <nw/snd/fnd/basis/sndfnd_Time.h>

#ifdef NW_PLATFORM_WIN32
#include <windows.h>
#endif

#if !defined(NW_RELEASE)
//#define NW_ENABLE_COM_DEBUG
#endif

namespace nw {
namespace snd {
namespace edit {
namespace internal {

const u32 HioSyncChannel::TIMEOUT_INFINITY = UINT_MAX;

//----------------------------------------------------------
HioResult
HioSyncChannel::Send(const HioPacket*& replyPacket, const HioPacket& message, u32 timeout /*= TIMEOUT_INFINITY*/)
{
    if(!IsInitialized())
    {
        replyPacket = &HioPacket::Null();
        return HioResult(HIO_RESULT_TARGET_NOT_INITIALIZED);
    }

    // メッセージを送信します。
    HioResult result = GetStream().WritePacket(message);

#if defined(NW_ENABLE_COM_DEBUG)
    NW_LOG(
        "[sndedit][HioSyncChannel]  send packet :  write : message=%s(0x%08x), Size=%d, BodySize=%d.\n",
        message.GetHeader().message.ToString(),
        u32(message.GetHeader().message),
        sizeof(HioPacketHeader) + message.GetHeader().bodySize,
        static_cast<u32>(message.GetHeader().bodySize));
#endif

    if(!result.IsTrue())
    {
        replyPacket = &HioPacket::Null();
        return HioResult(HIO_RESULT_TARGET_SEND_ERROR);
    }

    return Receive(replyPacket, timeout);
}

//----------------------------------------------------------
HioResult
HioSyncChannel::Receive(const HioPacket*& packet, u32 timeout /*= TIMEOUT_INFINITY*/)
{
    if(GetHioManager() == NULL)
    {
        return HioResult(HIO_RESULT_TARGET_NOT_INITIALIZED);
    }

    HioResult result = HioResult(HIO_RESULT_FALSE);

    snd::internal::fnd::StopWatch stopWatch;
    stopWatch.Start();

    for(;;)
    {
#if !defined(NW_PLATFORM_CTR)
        GetHioManager()->Update(false);
#endif

        result = GetStream().TryReadPacket();

        if(result.IsTrue())
        {
            packet = GetStream().GetReadPacket();
            break;
        }
        else if(!result.IsFalse())
        {
            break;
        }

        if(stopWatch.GetElapsedTime().ToMilliSeconds() >= timeout)
        {
            result = HioResult(HIO_RESULT_TARGET_TIMEOUT);
            break;
        }

#ifdef NW_PLATFORM_WIN32
        ::Sleep(0);
#endif
    }

#if defined(NW_ENABLE_COM_DEBUG)
    if(result.IsTrue())
    {
        NW_LOG(
            "[sndedit][HioSyncChannel] receive packet : time=%d : message=%s(0x%08x), Size=%d, BodySize=%d.\n",
            stopWatch.GetElapsedTime().ToMilliSeconds(),
            packet->GetHeader().message.ToString(),
            u32(packet->GetHeader().message),
            sizeof(HioPacketHeader) + packet->GetHeader().bodySize,
            static_cast<u32>(packet->GetHeader().bodySize));
    }
#endif

    return result;
}

} // namespace nw::snd::edit::internal
} // namespace nw::snd::edit
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV
