﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/edit/hio/sndedit_HioManager.h>

#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/snd/edit/hio/sndedit_HioAsyncChannel.h>
#include <nw/snd/edit/hio/sndedit_HioProtocol.h>

namespace nw {
namespace snd {
namespace edit {
namespace internal {

//----------------------------------------------------------
void
HioManager::Update(bool withAsyncChannels/*= true*/)
{
    if(!IsInitialized())
    {
        return;
    }

    if (!Polling(withAsyncChannels))
    {
        return;
    }

    UpdateAsyncChannels();
}

//----------------------------------------------------------
void
HioManager::RegisterChannel(HioChannel& channel)
{
#if !defined(NW_RELEASE)
    // 重複登録がないことをチェックします。
    for(HioChannelRefList::const_iterator it = HioChannelRefList::const_iterator(m_ChannelRefs.begin()); it != HioChannelRefList::const_iterator(m_ChannelRefs.end()); ++it)
    {
        NW_ASSERT(it->value != &channel);
    }
#endif

    m_ChannelRefs.push_back(&channel.GetReference());

    HioChannel::HioManagerLinker::SetHioManager(channel, this);
}

//----------------------------------------------------------
void
HioManager::UnregisterChannel(HioChannel& channel)
{
    // HACK: 多重 erase しないようにするための保護処理
    if(channel.GetReference().node.GetNext() == NULL &&
        channel.GetReference().node.GetPrev() == NULL)
    {
        return;
    }

    m_ChannelRefs.erase(&channel.GetReference());

    HioChannel::HioManagerLinker::SetHioManager(channel, NULL);
}

//----------------------------------------------------------
void
HioManager::UpdateAsyncChannels()
{
    // チャンネル毎に更新します。
    for(HioChannelRefList::const_iterator it = HioChannelRefList::const_iterator(m_ChannelRefs.begin()); it != HioChannelRefList::const_iterator(m_ChannelRefs.end()); ++it)
    {
        NW_ASSERT_NOT_NULL(it->value);
        if(!it->value->IsAsync())
        {
            continue;
        }

        HioAsyncChannel& asyncChannel = *reinterpret_cast<HioAsyncChannel*>(it->value);
        asyncChannel.Update();
    }
}

} // namespace nw::snd::edit::internal
} // namespace nw::snd::edit
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV
