﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/edit/hio/sndedit_HioManager.h>

#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/snd/fnd/io/sndfnd_File.h>
#include <nw/snd/fnd/io/sndfnd_HioFileStreamImpl.h>

namespace nw {
namespace snd {
namespace edit {
namespace internal {

//----------------------------------------------------------
HioManager::HioManager() :
m_IsInitialized(false)
{
}

//----------------------------------------------------------
bool
HioManager::Initialize()
{
    m_IsInitialized = true;
    return true;
}

//----------------------------------------------------------
void
HioManager::Finalize()
{
    m_IsInitialized = false;
}

//----------------------------------------------------------
u32
HioManager::GetRequiredMemorySizeForOpenFile()
{
    return sizeof(snd::internal::fnd::HioFileStreamImpl);
}

//----------------------------------------------------------
snd::internal::fnd::FileStream*
HioManager::OpenFile(void* buffer, u32 bufferLength, const char* filePath)
{
    if(!IsInitialized() ||
        buffer == NULL ||
        bufferLength < GetRequiredMemorySizeForOpenFile() ||
        filePath == NULL ||
        *filePath == '\0')
    {
        return NULL;
    }

    snd::internal::fnd::FileStream* result = new(buffer) snd::internal::fnd::HioFileStreamImpl();

    if(snd::internal::fnd::File::Open(
        result,
        filePath,
        snd::internal::fnd::File::ACCESS_MODE_READ
        ).IsFailed())
    {
        return NULL;
    }

    return result;
}

bool
HioManager::Polling(bool withAsyncChannels)
{
    // チャンネル毎にポーリング処理を行います。
    for(HioChannelRefList::const_iterator it = HioChannelRefList::const_iterator(m_ChannelRefs.begin()); it != HioChannelRefList::const_iterator(m_ChannelRefs.end()); ++it)
    {
        it->value->Polling();
    }

    if (!withAsyncChannels/* || !mcs::Mcs_IsServerConnect()*/)
    {
        return false;
    }

    return true;
}

} // namespace nw::snd::edit::internal
} // namespace nw::snd::edit
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV
