﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/edit/hio/sndedit_HioManager.h>

#ifdef NW_SND_CONFIG_ENABLE_DEV

#if defined(NW_SND_EDIT_USE_MCS)
#include <nw/mcs.h>
#else
#include <cafe/hio.h>
#endif

#include <nw/snd/fnd/io/sndfnd_File.h>
#include <nw/snd/fnd/io/sndfnd_FileStreamImpl.h>

namespace nw {
namespace snd {
namespace edit {
namespace internal {

//----------------------------------------------------------
HioManager::HioManager() :
m_IsInitialized(false),
m_FsClient(NULL)
{
}

//----------------------------------------------------------
bool
HioManager::Initialize(FSClient* fsClient /*= NULL*/)
{
    if(IsInitialized())
    {
        return true;
    }

#if defined(NW_SND_EDIT_USE_MCS)
    mcs::Mcs_Initialize();
    mcs::FileIO_Initialize();

    if (mcs::Mcs_Open() != mcs::MCS_ERROR_SUCCESS)
    {
        NW_WARNING(false, "failed to Mcs_Open().");
        Finalize();
        return false;
    }
#endif

    m_FsClient = fsClient;
    m_IsInitialized = true;

    return true;
}

//----------------------------------------------------------
void
HioManager::Finalize()
{
    if(!IsInitialized())
    {
        return;
    }

#if defined(NW_SND_EDIT_USE_MCS)
    mcs::Mcs_Close();

    mcs::FileIO_Finalize();
    mcs::Mcs_Finalize();
#endif

    m_FsClient = NULL;
    m_IsInitialized = false;
}

//----------------------------------------------------------
u32
HioManager::GetRequiredMemorySizeForOpenFile()
{
    return sizeof(snd::internal::fnd::FileStreamImpl);
}

//----------------------------------------------------------
snd::internal::fnd::FileStream*
HioManager::OpenFile(void* buffer, u32 bufferLength, const char* filePath, FSCmdBlock* fsCmdBlock)
{
    NW_ASSERT_NOT_NULL(m_FsClient);
    NW_ASSERT_NOT_NULL(fsCmdBlock);

    if(!IsInitialized() ||
        m_FsClient == NULL ||
        buffer == NULL ||
        bufferLength < GetRequiredMemorySizeForOpenFile() ||
        filePath == NULL ||
        *filePath == '\0')
    {
        return NULL;
    }

    snd::internal::fnd::FileStream* result = new(buffer) snd::internal::fnd::FileStreamImpl();

    if(snd::internal::fnd::File::Open(
        result,
        m_FsClient,
        fsCmdBlock,
        filePath,
        snd::internal::fnd::File::ACCESS_MODE_READ
        ).IsFailed())
    {
        return NULL;
    }

    return result;
}

bool
HioManager::Polling(bool withAsyncChannels)
{

#if defined(NW_SND_EDIT_USE_MCS)
    mcs::Mcs_Polling();

    if (!withAsyncChannels || !mcs::Mcs_IsServerConnect())
    {
        return false;
    }

    return true;
#else
    if (!withAsyncChannels)
    {
        return false;
    }

    return true;
#endif
}

} // namespace nw::snd::edit::internal
} // namespace nw::snd::edit
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV
