﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/edit/handler/sndedit_SyncReplyHandler.h>

#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/snd/edit/sndedit_SoundEditSession.h>

namespace nw {
namespace snd {
namespace edit {
namespace internal {

//----------------------------------------------------------
void
SyncReplyHandler::Initialize(SoundEditSession& session)
{
    m_Session = &session;
}

//----------------------------------------------------------
void
SyncReplyHandler::Finalize()
{
    m_Session = NULL;
}

//----------------------------------------------------------
HioResult
SyncReplyHandler::OnInvokeForReadTargetPacket(const SyncReplyPacket& packet, HioPacketStream& /*stream*/)
{
    if(m_Session == NULL)
    {
        return HioResult(HIO_RESULT_TARGET_NOT_INITIALIZED);
    }

    if(packet.GetBody().isAccepted)
    {
        m_Session->Connect();
    }
    else
    {
        m_Session->Disconnect();
    }

    return HioResult(HIO_RESULT_TRUE);
}

} // namespace nw::snd::edit::internal
} // namespace nw::snd::edit
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV
