﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/edit/sndedit_SoundEditConnection.h>

#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/snd/fnd/string/sndfnd_String.h>
#include <nw/snd/fnd/string/sndfnd_Path.h>
#include <nw/snd/edit/sndedit_Config.h>
#include <nw/snd/edit/protocol/sndedit_QueryItemInfoPacket.h>

namespace nw {
namespace snd {
namespace edit {
namespace internal {

//----------------------------------------------------------
SoundEditConnection::SoundEditConnection() :
m_SoundArchiveEditor(NULL),
m_HioManager(NULL),
m_SyncChannel(NULL),
m_FuncChannel(NULL),
m_CacheSyncInterval(0),
m_SendTimeout(0),
m_SendPacketBufferSize(0)
{
}

//----------------------------------------------------------
Result
SoundEditConnection::Initialize(const InitializeArgs& args)
{
    if(IsInitialized())
    {
        NW_FATAL_ERROR("SoundEditConnection is already initialized.\n");
        return Result(SNDEDIT_RESULT_FAILED);
    }

    if(args.buffer == NULL ||
        args.cacheSyncInterval == 0 ||
        args.sendTimeout == 0 ||
        args.maxItemName == 0 ||
        args.hioManager == NULL ||
        args.syncChannel == NULL ||
        args.funcChannel == NULL ||
        !args.syncChannel->IsOpened() ||
        !args.funcChannel->IsOpened())
    {
        NW_FATAL_ERROR("invalid arguments.\n");
        return Result(SNDEDIT_RESULT_FAILED);
    }

    u32 queryItemInfoPacketBufferSize =
        internal::QueryItemInfoPacket::GetRequiredSize(args.maxItemName);

    if(args.bufferLength < queryItemInfoPacketBufferSize)
    {
        return Result(SNDEDIT_RESULT_OUT_OF_MEMORY);
    }

    m_SendPacketBuffer = reinterpret_cast<QueryItemInfoPacket*>(args.buffer);
    m_SendPacketBufferSize = queryItemInfoPacketBufferSize;

    m_HioManager = args.hioManager;
    m_SyncChannel = args.syncChannel;
    m_FuncChannel = args.funcChannel;
    m_CacheSyncInterval = args.cacheSyncInterval;
    m_SendTimeout = args.sendTimeout;

    SetupSyncChannel(args.maxItemName);

    return Result(SNDEDIT_RESULT_TRUE);
}

//----------------------------------------------------------
snd::internal::fnd::FileStream*
SoundEditConnection::OpenFile(void* buffer, u32 bufferLength, const char* filePath)
{
    if(!IsInitialized())
    {
        NW_FATAL_ERROR("SoundEditConnection is not initialized.\n");
        return NULL;
    }

    if(!IsOpened())
    {
        return NULL;
    }

    snd::internal::fnd::FileStream* result = m_HioManager->OpenFile(buffer, bufferLength, filePath);

    if(result == NULL)
    {
        NW_LOG("[sndedit] failed to open file : filepath=%s.\n", filePath);
    }

    return result;
}

} // namespace nw::snd::edit::internal
} // namespace nw::snd::edit
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV
