﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dw/system/dw_Types.h>
#include <nw/snd/dw/snddw_MasterOutputWindow.h>
#include <nw/snd/dw/snddw_Config.h>

namespace nw {
namespace snd {
namespace dw {

//------------------------------------------------------------------------------
MasterOutputWindow::MasterOutputWindow()
: m_Panel()
, m_MemoryForPanel(NULL)
{
    SetTitle("MasterOutput");
    SetSize(488, 361);
    SetMaximumSize(nw::math::Vector2(488, 400));

    m_Panel.SetMeasurement(nw::internal::dw::MEASUREMENT_MANUAL);
    SetContent(&m_Panel);
}

//------------------------------------------------------------------------------
MasterOutputWindow::~MasterOutputWindow()
{
}

//------------------------------------------------------------------------------
void MasterOutputWindow::StartMonitoring()
{
    m_Panel.StartMonitoring();
}

//------------------------------------------------------------------------------
void MasterOutputWindow::StopMonitoring()
{
    m_Panel.StopMonitoring();
}

//------------------------------------------------------------------------------
u32 MasterOutputWindow::GetRequiredSize() const
{
    const u32 titleLenMax = Config::GetInstance().GetWindowTitleLengthMax();
    const u32 stringBufferSize = font::CharWriter::GetDispStringBufferSize( titleLenMax );
    const u32 graphicsBufferSize = font::CharWriter::GetGraphicsBufferSize( titleLenMax );
    const u32 waveGraphDrawBufferSize = m_Panel.GetRequiredSize();

    return 44 * 1024 + stringBufferSize + graphicsBufferSize + waveGraphDrawBufferSize;
}

void MasterOutputWindow::OnInitialize()
{
    const u32 waveGraphDrawBufferSize = m_Panel.GetRequiredSize();
    m_MemoryForPanel = Alloc(waveGraphDrawBufferSize);
    m_Panel.Initialize(m_MemoryForPanel, waveGraphDrawBufferSize);

    StartMonitoring();
}

void MasterOutputWindow::OnFinalize()
{
    StopMonitoring();

    m_Panel.Finalize();
    Free(m_MemoryForPanel);
    m_MemoryForPanel = NULL;
}

} // namespace dw
} // namespace snd
} // namespace nw
