﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/dw/snddw_Config.h>
#include <nw/snd/dw/snddw_SoundWindow.h>

namespace nw {
namespace snd {
namespace dw {

//------------------------------------------------------------------------------
Config&
Config::GetInstance()
{
    static Config instance;

    return instance;
}

//------------------------------------------------------------------------------
void
Config::SetWindowTitleLengthMax(u32 value)
{
    NW_ASSERT(!m_IsSealed);
    NW_ASSERT(value < SoundWindow::TITLE_LEN_MAX);

    m_WindowTitleLengthMax = value;
}

//------------------------------------------------------------------------------
void
Config::SetWindowMax(u32 value)
{
    NW_ASSERT(!m_IsSealed);

    m_WindowMax = value;
}

//------------------------------------------------------------------------------
u32
Config::GetWindowTitleLengthMax() const
{
    return m_WindowTitleLengthMax;
}

//------------------------------------------------------------------------------
u32
Config::GetWindowMax() const
{
    return m_WindowMax;
}

//------------------------------------------------------------------------------
Config::Config()
: m_WindowTitleLengthMax(32)
, m_WindowMax(16)
, m_IsSealed(false)
{
}

//------------------------------------------------------------------------------
void
Config::Seal()
{
    m_IsSealed = true;
}

} // namespace dw
} // namespace snd
} // namespace nw
