﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/ctrl/sndctrl_SoundControllerImpl.h>

#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/ut/ut_Inlines.h>
#include <nw/snd/snd_SoundHandle.h>
#include <nw/snd/snd_StreamSoundHandle.h>
#include <nw/snd/snd_SequenceSoundHandle.h>
#include <nw/snd/snd_SoundArchive.h>
#include <nw/snd/snd_SoundArchivePlayer.h>

namespace nw {
namespace snd {
namespace ctrl {
namespace internal {

//----------------------------------------------------------
void
SoundControllerImpl::UpdateParameters()
{
    if(!m_IsParameterDirty)
    {
        return;
    }

    if(!m_SoundHandle->IsAttachedSound())
    {
        return;
    }

    // 全体設定
    m_SoundHandle->SetVolume(m_Parameters.volume);
    m_SoundHandle->SetPan(m_Parameters.pan);
    m_SoundHandle->SetSurroundPan(m_Parameters.surroundPan);
    m_SoundHandle->SetMainSend(m_Parameters.mainSend);
    m_SoundHandle->SetFxSend(AUX_BUS_A, m_Parameters.fxSend[0]);
    m_SoundHandle->SetFxSend(AUX_BUS_B, m_Parameters.fxSend[1]);
    m_SoundHandle->SetFxSend(AUX_BUS_C, m_Parameters.fxSend[2]);

    // MAIN設定
    m_SoundHandle->SetOutputVolume(OUTPUT_DEVICE_MAIN, m_Parameters.mainOutVolume);
    m_SoundHandle->SetOutputPan(OUTPUT_DEVICE_MAIN, m_Parameters.mainPan);
    m_SoundHandle->SetOutputSurroundPan(OUTPUT_DEVICE_MAIN, m_Parameters.mainSurroundPan);
    m_SoundHandle->SetOutputMainSend(OUTPUT_DEVICE_MAIN, m_Parameters.mainMainSend);
    m_SoundHandle->SetOutputFxSend(OUTPUT_DEVICE_MAIN, AUX_BUS_A, m_Parameters.mainFxSend[0]);
    m_SoundHandle->SetOutputFxSend(OUTPUT_DEVICE_MAIN, AUX_BUS_B, m_Parameters.mainFxSend[1]);
    m_SoundHandle->SetOutputFxSend(OUTPUT_DEVICE_MAIN, AUX_BUS_C, m_Parameters.mainFxSend[2]);

    // DRC設定
    for(u32 index = 0; index < Limits::MAX_DRC_COUNT; ++index)
    {
        m_SoundHandle->SetOutputVolume(OUTPUT_DEVICE_DRC, m_Parameters.drcOutVolume[index]);
        m_SoundHandle->SetOutputPan(OUTPUT_DEVICE_DRC, m_Parameters.drcPan[index]);
        m_SoundHandle->SetOutputSurroundPan(OUTPUT_DEVICE_DRC, m_Parameters.drcSurroundPan[index]);
        m_SoundHandle->SetOutputMainSend(OUTPUT_DEVICE_DRC, m_Parameters.drcMainSend[index]);
        m_SoundHandle->SetOutputFxSend(OUTPUT_DEVICE_DRC, AUX_BUS_A, m_Parameters.drcFxSend[index][0]);
        m_SoundHandle->SetOutputFxSend(OUTPUT_DEVICE_DRC, AUX_BUS_B, m_Parameters.drcFxSend[index][1]);
        m_SoundHandle->SetOutputFxSend(OUTPUT_DEVICE_DRC, AUX_BUS_C, m_Parameters.drcFxSend[index][2]);
    }

    // リモート設定
    for(u32 index = 0; index < Limits::MAX_REMOTE_COUNT; ++index)
    {
        m_SoundHandle->SetRemoteOutVolume(index, m_Parameters.remoteOutVolume[index]);
    }

    // 共通設定
    m_SoundHandle->SetPitch(m_Parameters.pitch);
    m_SoundHandle->SetLpfFreq(m_Parameters.lpfFrequency);
    m_SoundHandle->SetBiquadFilter(m_Parameters.biquadFilterType, m_Parameters.biquadFilterValue);

    u32 outputLine = 0;

    if(m_Parameters.isMainOutEnabled)
    {
        outputLine |= OUTPUT_LINE_MAIN;
    }
    if(m_Parameters.isDrcOutEnabled[0])
    {
        outputLine |= OUTPUT_LINE_DRC0;
    }
    if(m_Parameters.isDrcOutEnabled[1])
    {
        outputLine |= OUTPUT_LINE_DRC1;
    }
    if(m_Parameters.isRemoteOutEnabled[0])
    {
        outputLine |= OUTPUT_LINE_REMOTE0;
    }
    if(m_Parameters.isRemoteOutEnabled[1])
    {
        outputLine |= OUTPUT_LINE_REMOTE1;
    }
    if(m_Parameters.isRemoteOutEnabled[2])
    {
        outputLine |= OUTPUT_LINE_REMOTE2;
    }
    if(m_Parameters.isRemoteOutEnabled[3])
    {
        outputLine |= OUTPUT_LINE_REMOTE3;
    }

    m_SoundHandle->SetOutputLine(outputLine);

    SoundArchive::SoundType soundType = m_SoundArchivePlayer->GetSoundArchive().GetSoundType(m_SoundID);

    switch(soundType)
    {
    case nw::snd::SoundArchive::SOUND_TYPE_STRM:
        {
            StreamSoundHandle streamSoundHandle(m_SoundHandle);
            u32 trackFlag = 0x1;

            for (u32 index = 0; index < Limits::MAX_STREAM_TRACK_COUNT; ++index)
            {
                if (m_Parameters.tracksMute[index])
                {
                    streamSoundHandle.SetTrackVolume(trackFlag, 0.0f);
                }
                else
                {
                    streamSoundHandle.SetTrackVolume(trackFlag, m_Parameters.tracksVolume[index]);
                }

                trackFlag <<= 1;
            }
        }
        break;

    case nw::snd::SoundArchive::SOUND_TYPE_SEQ:
        {
            SequenceSoundHandle sequenceSoundHandle(m_SoundHandle);
            u32 trackFlag = 0x1;

            for (u32 index = 0; index < Limits::MAX_SEQUENCE_TRACK_COUNT; ++index)
            {
                sequenceSoundHandle.SetTrackMute(trackFlag, m_Parameters.tracksMute[index]);
                sequenceSoundHandle.SetTrackVolume(trackFlag, m_Parameters.tracksVolume[index]);
                trackFlag <<= 1;
            }
        }
        break;

    default:
        break;
    }

    ApplySequenceVariables();

    m_IsParameterDirty = false;
}

} // namespace nw::snd::ctrl::internal
} // namespace nw::snd::ctrl
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV
