﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/snd_WaveFile.h>
#include <nw/snd/snd_ElementType.h>

#include <nw/ut/ut_Inlines.h>               // ut::AddOffsetToPtr

namespace nw {
namespace snd {
namespace internal {

//
// WaveFile::FileHeader
//
const WaveFile::InfoBlock* WaveFile::FileHeader::GetInfoBlock() const
{
    return reinterpret_cast<const InfoBlock*>( GetBlock( ElementType_WaveFile_InfoBlock ) );
}

const WaveFile::DataBlock* WaveFile::FileHeader::GetDataBlock() const
{
    return reinterpret_cast<const DataBlock*>( GetBlock( ElementType_WaveFile_DataBlock ) );
}


//
// WaveFile::InfoBlockBody
//
const WaveFile::ChannelInfo&
WaveFile::InfoBlockBody::GetChannelInfo( s32 channelIndex ) const
{
    NW_ASSERT( channelIndex < GetChannelCount() );
    return *reinterpret_cast<const ChannelInfo*>(
            channelInfoReferenceTable.GetReferedItem( channelIndex ) );
}


//
// WaveFile::ChannelInfo
//
const void*
WaveFile::ChannelInfo::GetSamplesAddress( const void* dataBlockBodyAddress ) const
{
    return reinterpret_cast<const void*>(
            ut::AddOffsetToPtr( dataBlockBodyAddress, referToSamples.offset ) );
}

const WaveFile::DspAdpcmInfo&
WaveFile::ChannelInfo::GetDspAdpcmInfo() const
{
    return *reinterpret_cast<const DspAdpcmInfo*>(
            ut::AddOffsetToPtr( this, referToAdpcmInfo.offset ) );
}


} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw
