﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/snd_WaveArchiveFile.h>

#include <nw/snd/snd_ElementType.h>

namespace nw {
namespace snd {
namespace internal {


//
// WaveArchiveFile::FileHeader
//
const WaveArchiveFile::InfoBlock*
WaveArchiveFile::FileHeader::GetInfoBlock() const
{
    return reinterpret_cast<const InfoBlock*>(
            ut::AddOffsetToPtr( this, GetInfoBlockOffset() ) );
}
const WaveArchiveFile::FileBlock*
WaveArchiveFile::FileHeader::GetFileBlock() const
{
    return reinterpret_cast<const FileBlock*>(
            ut::AddOffsetToPtr( this, GetFileBlockOffset() ) );
}

u32 WaveArchiveFile::FileHeader::GetInfoBlockSize() const
{
    return GetReferenceBy( ElementType_WaveArchiveFile_InfoBlock )->size;
}
u32 WaveArchiveFile::FileHeader::GetFileBlockSize() const
{
    return GetReferenceBy( ElementType_WaveArchiveFile_FileBlock )->size;
}
u32 WaveArchiveFile::FileHeader::GetInfoBlockOffset() const
{
    return GetReferenceBy( ElementType_WaveArchiveFile_InfoBlock )->offset;
}
u32 WaveArchiveFile::FileHeader::GetFileBlockOffset() const
{
    return GetReferenceBy( ElementType_WaveArchiveFile_FileBlock )->offset;
}
const Util::ReferenceWithSize*
WaveArchiveFile::FileHeader::GetReferenceBy( u16 typeId ) const
{
    for ( int i = 0; i < BLOCK_SIZE; i++ )
    {
        if ( toBlocks[ i ].typeId == typeId )
        {
            return &toBlocks[ i ];
        }
    }

    NW_ASSERT(false); // should not reach here.
    return NULL;
}



} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw
