﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/snd_StreamSoundFile.h>
#include <nw/snd/snd_ElementType.h>

namespace nw {
namespace snd {
namespace internal {


//
// StreamSoundFile::FileHeader
//
const Util::ReferenceWithSize*
StreamSoundFile::FileHeader::GetReferenceBy( u16 typeId ) const
{
    for ( int i = 0; i < dataBlocks; i++ )
    {
        if ( toBlocks[ i ].typeId == typeId )
        {
            return &toBlocks[ i ];
        }
    }
    return NULL;
}

bool StreamSoundFile::FileHeader::HasSeekBlock() const
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_SeekBlock );
    return (p != NULL);
}
bool StreamSoundFile::FileHeader::HasRegionBlock() const
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_RegionBlock );
    return (p != NULL);
}

u32 StreamSoundFile::FileHeader::GetInfoBlockSize() const
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_InfoBlock );
    NW_NULL_ASSERT(p);
    return p->size;
}
u32 StreamSoundFile::FileHeader::GetSeekBlockSize() const
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_SeekBlock );
    NW_NULL_ASSERT(p);
    return p->size;
}
u32 StreamSoundFile::FileHeader::GetDataBlockSize() const
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_DataBlock );
    NW_NULL_ASSERT(p);
    return p->size;
}
u32 StreamSoundFile::FileHeader::GetRegionBlockSize() const
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_RegionBlock );
    NW_NULL_ASSERT(p);
    return p->size;
}

u32 StreamSoundFile::FileHeader::GetInfoBlockOffset() const
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_InfoBlock );
    NW_NULL_ASSERT(p);
    return p->offset;
}
u32 StreamSoundFile::FileHeader::GetSeekBlockOffset() const
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_SeekBlock );
    NW_NULL_ASSERT(p);
    return p->offset;
}
u32 StreamSoundFile::FileHeader::GetDataBlockOffset() const
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_DataBlock );
    NW_NULL_ASSERT(p);
    return p->offset;
}
u32 StreamSoundFile::FileHeader::GetRegionBlockOffset() const
{
    const Util::ReferenceWithSize* p =
        GetReferenceBy( ElementType_StreamSoundFile_RegionBlock );
    NW_NULL_ASSERT(p);
    return p->offset;
}


//
// StreamSoundFile::InfoBlockBody
//

const StreamSoundFile::StreamSoundInfo*
StreamSoundFile::InfoBlockBody::GetStreamSoundInfo() const
{
    if ( toStreamSoundInfo.typeId != ElementType_StreamSoundFile_StreamSoundInfo )
    {
        return NULL;
    }
    return static_cast<const StreamSoundInfo*>(
            ut::AddOffsetToPtr( this, toStreamSoundInfo.offset ) );
}
const StreamSoundFile::TrackInfoTable*
StreamSoundFile::InfoBlockBody::GetTrackInfoTable() const
{
    if ( toTrackInfoTable.typeId != ElementType_Table_ReferenceTable )
    {
        return NULL;
    }
    return static_cast<const TrackInfoTable*>(
            ut::AddOffsetToPtr( this, toTrackInfoTable.offset ) );
}
const StreamSoundFile::ChannelInfoTable*
StreamSoundFile::InfoBlockBody::GetChannelInfoTable() const
{
    if ( toChannelInfoTable.typeId != ElementType_Table_ReferenceTable )
    {
        return NULL;
    }
    return static_cast<const ChannelInfoTable*>(
            ut::AddOffsetToPtr( this, toChannelInfoTable.offset ) );
}

//
// StreamSoundFile::TrackInfoTable
//
const StreamSoundFile::TrackInfo*
StreamSoundFile::TrackInfoTable::GetTrackInfo( u32 index ) const
{
    return static_cast<const TrackInfo*>(
            table.GetReferedItem( index, ElementType_StreamSoundFile_TrackInfo ) );
}

//
// StreamSoundFile::ChannelInfoTable
//
const StreamSoundFile::ChannelInfo*
StreamSoundFile::ChannelInfoTable::GetChannelInfo( u32 index ) const
{
    NW_ASSERT( index < table.count );

    return static_cast<const ChannelInfo*>(
            table.GetReferedItem(
                index,
                ElementType_StreamSoundFile_ChannelInfo ) );
}

//
// StreamSoundFile::ChannlInfo
//
const StreamSoundFile::DspAdpcmChannelInfo*
StreamSoundFile::ChannelInfo::GetDspAdpcmChannelInfo() const
{
    if ( ! toDetailChannelInfo.IsValidTypeId( ElementType_Codec_DspAdpcmInfo ) )
    {
        return NULL;
    }

    return reinterpret_cast<const DspAdpcmChannelInfo*>(
            ut::AddOffsetToPtr( this, toDetailChannelInfo.offset ) );
}

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

