﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/snd_SoundStartable.h>
#include <nw/snd/snd_SoundHandle.h>
#include <nw/snd/snd_Debug.h>

namespace nw {
namespace snd {

#if 0
const char* SoundStartable::detail_ConvertStartResultToString( SoundStartable::StartResult startResult )
{
    static const int resultStringsSize = 15;
    static const char* resultStrings[ resultStringsSize ] =
    {
        "START_SUCCESS",
        "START_ERR_LOW_PRIORITY",
        "START_ERR_INVALID_LABEL_STRING",
        "START_ERR_INVALID_SOUNDID",
        "START_ERR_NOT_DATA_LOADED",
        "START_ERR_NOT_SEQ_LOADED",
        "START_ERR_NOT_BANK_LOADED",
        "START_ERR_NOT_WSD_LOADED",
        "START_ERR_NOT_WARC_LOADED",
        "START_ERR_NOT_ENOUGH_PLAYER_HEAP",
        "START_ERR_CANNOT_OPEN_FILE",
        "START_ERR_NOT_AVAILABLE",
        "START_ERR_CANNOT_ALLOCATE_TRACK",
        "START_ERR_NOT_ENOUGH_INSTANCE",
        "START_ERR_INVALID_PARAMETER"
    };

    static const char resultStrings128[] = "START_ERR_USER";
    static const char resultStrings255[] = "START_ERR_UNKNOWN";
    static const char nullStrings[] = "";

    if ( startResult < resultStringsSize )
    {
        return resultStrings[ startResult ];
    }
    else if ( startResult == START_ERR_USER )
    {
        return resultStrings128;
    }
    else if ( startResult == START_ERR_UNKNOWN )
    {
        return resultStrings255;
    }
    else
    {
        return nullStrings;
    }
}
#endif

/*---------------------------------------------------------------------------*
  Name:         detail_StartSound

  Description:  指定したサウンド番号のサウンドを再生する

  Arguments:    handle  - サウンドハンドル
                soundId - サウンドＩＤ
                startInfo - 再生パラメータ

  Returns:      結果コード
 *---------------------------------------------------------------------------*/
SoundStartable::StartResult SoundStartable::StartSound(
    SoundHandle* handle,
    u32 soundId,
    const StartInfo* startInfo
)
{
    NW_SND_LOG_APICALL_NW("StartSound [ID:%08x]", soundId);

    StartResult result = detail_SetupSound(
        handle,
        soundId,
        false,
        startInfo
    );
    if ( ! result.IsSuccess() ) return result;
    handle->StartPrepared();
    StartResult result2( StartResult::START_SUCCESS );
    return result2;
}

/*---------------------------------------------------------------------------*
  Name:         detail_StartSound

  Description:  指定したサウンド番号のサウンドを再生する

  Arguments:    handle  - サウンドハンドル
                soundName - サウンド名
                startInfo - 再生パラメータ

  Returns:      結果コード
 *---------------------------------------------------------------------------*/
SoundStartable::StartResult SoundStartable::StartSound(
    SoundHandle* handle,
    const char* soundName,
    const StartInfo* startInfo
)
{
    u32 soundId = detail_GetItemId( soundName );
    NW_SND_LOG_APICALL_NW("StartSound [Name:%s ID:%08x]", soundName,soundId);

    if ( soundId == SoundArchive::INVALID_ID )
    {
        StartResult result( StartResult::START_ERR_INVALID_LABEL_STRING );
        return result;
    }
    StartResult result = detail_SetupSound(
        handle,
        soundId,
        false,
        startInfo
    );
    if ( ! result.IsSuccess() ) return result;
    handle->StartPrepared();
    StartResult result2( StartResult::START_SUCCESS );
    return result2;
}

/*---------------------------------------------------------------------------*
  Name:         detail_HoldSound

  Description:  指定したサウンド番号のサウンドを再生する

  Arguments:    handle  - サウンドハンドル
                soundNo - サウンド番号
                startInfo - 再生パラメータ

  Returns:      結果コード
 *---------------------------------------------------------------------------*/
SoundStartable::StartResult SoundStartable::HoldSound(
    SoundHandle* handle,
    u32 soundId,
    const StartInfo* startInfo
)
{
    if ( handle->IsAttachedSound() && ( handle->GetId() == soundId ) )
    {
        handle->detail_GetAttachedSound()->SetAutoStopCounter( 1 );
        if ( (startInfo != NULL) && (startInfo->enableFlag & StartInfo::ENABLE_FADE_FRAME) )
        {
            handle->Stop( startInfo->fadeFrame );
        }
        StartResult result( StartResult::START_SUCCESS );
        return result;
    }

    StartResult result = detail_SetupSound(
        handle,
        soundId,
        true,
        startInfo
    );
    if ( ! result.IsSuccess() ) return result;
    handle->StartPrepared();
    handle->detail_GetAttachedSound()->SetAutoStopCounter( 1 );
    if ( (startInfo != NULL) && (startInfo->enableFlag & StartInfo::ENABLE_FADE_FRAME) )
    {
        handle->Stop( startInfo->fadeFrame );
    }
    StartResult result2( StartResult::START_SUCCESS );
    return result2;
}

/*---------------------------------------------------------------------------*
  Name:         detail_HoldSound

  Description:  指定したサウンド番号のサウンドを再生する

  Arguments:    handle  - サウンドハンドル
                soundLabel - サウンドラベル
                startInfo - 再生パラメータ

  Returns:      結果コード
 *---------------------------------------------------------------------------*/
SoundStartable::StartResult SoundStartable::HoldSound(
    SoundHandle* handle,
    const char* soundLabel,
    const StartInfo* startInfo
)
{
    u32 soundId = detail_GetItemId( soundLabel );
    if ( soundId == SoundArchive::INVALID_ID )
    {
        StartResult result( StartResult::START_ERR_INVALID_LABEL_STRING );
        return result;
    }
    return HoldSound( handle, soundId, startInfo );
}

/*---------------------------------------------------------------------------*
  Name:         detail_PrepareSound

  Description:  指定したサウンド番号のサウンドを再生する

  Arguments:    handle  - サウンドハンドル
                soundNo - サウンド番号
                startInfo - 再生パラメータ

  Returns:      結果コード
 *---------------------------------------------------------------------------*/
SoundStartable::StartResult SoundStartable::PrepareSound(
    SoundHandle* handle,
    u32 soundId,
    const StartInfo* startInfo
)
{
    return detail_SetupSound(
        handle,
        soundId,
        false,
        startInfo
    );
}

/*---------------------------------------------------------------------------*
  Name:         detail_PrepareSound

  Description:  指定したサウンド番号のサウンドを再生する

  Arguments:    handle  - サウンドハンドル
                soundLabel - サウンドラベル
                startInfo - 再生パラメータ

  Returns:      結果コード
 *---------------------------------------------------------------------------*/
SoundStartable::StartResult SoundStartable::PrepareSound(
    SoundHandle* handle,
    const char* soundName,
    const StartInfo* startInfo
)
{
    u32 soundId = detail_GetItemId( soundName );
    if ( soundId == SoundArchive::INVALID_ID )
    {
        StartResult result( StartResult::START_ERR_INVALID_LABEL_STRING );
        return result;
    }
    return PrepareSound( handle, soundId, startInfo );
}

} // namespace nw::snd
} // namespace nw

