﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/snd_MmlSequenceTrackAllocator.h>

namespace nw {
namespace snd {
namespace internal {
namespace driver {

/* ========================================================================
        static member function
   ======================================================================== */


/*---------------------------------------------------------------------------*
  Name:         AllocTrack

  Description:  トラックを確保します

  Arguments:    None.

  Returns:      確保できたときは、トラックID
                確保できなかったときは、-1 を返します
 *---------------------------------------------------------------------------*/
SequenceTrack* MmlSequenceTrackAllocator::AllocTrack( SequenceSoundPlayer* player )
{
    MmlSequenceTrack* track = m_TrackPool.Alloc();
    if ( track != NULL )
    {
        track->SetSequenceSoundPlayer( player );
        track->SetMmlParser( m_pParser );
    }
    return track;
}

/*---------------------------------------------------------------------------*
  Name:         FreeTrack

  Description:  トラックを開放します

  Arguments:    trackID - トラックID

  Returns:      None.
 *---------------------------------------------------------------------------*/
void MmlSequenceTrackAllocator::FreeTrack( SequenceTrack* track )
{
    NW_NULL_ASSERT( track );

    track->SetSequenceSoundPlayer( NULL );

    m_TrackPool.Free( reinterpret_cast<MmlSequenceTrack*>( track ) ); // TODO: 気になるキャスト
}

unsigned long MmlSequenceTrackAllocator::Create( void* buffer, unsigned long size )
{
    return m_TrackPool.Create( buffer, size );
}

void MmlSequenceTrackAllocator::Destroy()
{
    m_TrackPool.Destroy();
}

} // namespace nw::snd::internal::driver
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

