﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/snd_MidiSequenceTrackAllocator.h>

namespace nw {
namespace snd {
namespace internal {
namespace driver {


/* ========================================================================
        static member function
   ======================================================================== */


/*---------------------------------------------------------------------------*
  Name:         AllocTrack

  Description:  トラックを確保します

  Arguments:    None.

  Returns:      確保できたときは、トラックID
                確保できなかったときは、-1 を返します
 *---------------------------------------------------------------------------*/
SequenceTrack* MidiSequenceTrackAllocator::AllocTrack( SequenceSoundPlayer* player )
{
    MidiSequenceTrack* track = m_TrackPool.Alloc();
    if ( track != NULL )
    {
        track->SetSequenceSoundPlayer( player );
    }
    return track;
}

/*---------------------------------------------------------------------------*
  Name:         FreeTrack

  Description:  トラックを開放します

  Arguments:    trackID - トラックID

  Returns:      None.
 *---------------------------------------------------------------------------*/
void MidiSequenceTrackAllocator::FreeTrack( SequenceTrack* track )
{
    NW_NULL_ASSERT( track );

    track->SetSequenceSoundPlayer( NULL );

    m_TrackPool.Free( reinterpret_cast<MidiSequenceTrack*>( track ) ); // TODO: 気になるキャスト
}

/*---------------------------------------------------------------------------*
  Name:         GetAllocatableTrackCount

  Description:  確保可能なトラック数を返します

  Arguments:    なし

  Returns:      トラック数
 *---------------------------------------------------------------------------*/
int MidiSequenceTrackAllocator::GetAllocatableTrackCount() const
{
    return m_TrackPool.Count();
}

/*---------------------------------------------------------------------------*
  Name:         Create

  Description:  インスタンスプールを作成します

  Arguments:    buffer - バッファ
                size - バッファサイズ

  Returns:      作成したプール中のインスタンス数
 *---------------------------------------------------------------------------*/
unsigned long MidiSequenceTrackAllocator::Create( void* buffer, unsigned long size )
{
    return m_TrackPool.Create( buffer, size );
}

/*---------------------------------------------------------------------------*
  Name:         Destroy

  Description:  インスタンスプールを破棄します

  Arguments:    buffer - バッファ
                size - バッファサイズ

  Returns:      なし
 *---------------------------------------------------------------------------*/
void MidiSequenceTrackAllocator::Destroy()
{
    m_TrackPool.Destroy();
}

} // namespace nw::snd::internal::driver
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

