﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#if defined( NW_PLATFORM_CAFE )
    #include <cafe/ax.h>
#elif defined( NW_PLATFORM_WIN32 )
    #include <winext/cafe/ax.h>
#elif defined( NW_PLATFORM_ANDROID ) || defined( NW_PLATFORM_IOS )
    #include <winext/cafe/ax.h>
#elif defined( NW_USE_NINTENDO_SDK )
    // TODO: nn_audio
    #include <winext/cafe/ax.h>
#else
    #error
#endif

#include <nw/snd/snd_DrcWavOutRecorder.h>

#if defined( NW_PLATFORM_WIN32 )
using namespace nw::internal::winext;
#elif defined( NW_PLATFORM_ANDROID ) || defined( NW_PLATFORM_IOS )
using namespace nw::internal::winext;
#elif defined( NW_USE_NINTENDO_SDK )
// TODO: nn_audio
using namespace nw::internal::winext;
#endif

namespace nw {
namespace snd {

const char* DrcWavOutRecorder::DEVICE_NAME = "DRC";

DrcWavOutRecorder* DrcWavOutRecorder::s_pThis = NULL;

//---------------------------------------------------------------------------
DrcWavOutRecorder::DrcWavOutRecorder() :
DeviceOutRecorder(DEVICE_NAME)
{
}

//---------------------------------------------------------------------------
DrcWavOutRecorder::~DrcWavOutRecorder()
{
}

//---------------------------------------------------------------------------
void
DrcWavOutRecorder::OnStart()
{
    if(s_pThis != NULL)
    {
        NW_ASSERTMSG(false, "DrcOutRecorder instance is already existed.\n");
        return;
    }

    s_pThis = this;
#ifdef NW_SND_CONFIG_ENABLE_APPFRAMECALLBACK
    AXPB_ERROR_CODE error = AXRegisterAppFrameCallback(AxAppFrameCallbackFunc);
    NW_ASSERT(error == AXPB_ERROR_NONE);
#endif
}

//---------------------------------------------------------------------------
void
DrcWavOutRecorder::OnStop()
{
#ifdef NW_SND_CONFIG_ENABLE_APPFRAMECALLBACK
    AXPB_ERROR_CODE error = AXDeregisterAppFrameCallback(AxAppFrameCallbackFunc);
    NW_ASSERT(error == AXPB_ERROR_NONE);
#endif

    if(s_pThis == this)
    {
        s_pThis = NULL;
    }
}

//---------------------------------------------------------------------------
u32
DrcWavOutRecorder::OnProcessSamples(s16* sampleBuffer, u32 samples)
{
    NW_ASSERT_NOT_NULL(sampleBuffer);

    u32 channels = GetRecordingChannels();

    u32 destIndex = 0;

    for(u32 srcIndex = 0; srcIndex < samples ; srcIndex += channels, destIndex += channels)
    {
        NW_ASSERT(srcIndex >= destIndex);

        const s16 fl = ResolveSampleEndian(sampleBuffer[srcIndex + DMA_DRC_FL_INDEX]);
        const s16 fr = ResolveSampleEndian(sampleBuffer[srcIndex + DMA_DRC_FR_INDEX]);

        sampleBuffer[destIndex + DRC_FL_INDEX]  = fl;
        sampleBuffer[destIndex + DRC_FR_INDEX]  = fr;

        if(channels == 4)
        {
            const s16 rl  = ResolveSampleEndian(sampleBuffer[srcIndex + DMA_DRC_RL_INDEX]);
            const s16 rr  = ResolveSampleEndian(sampleBuffer[srcIndex + DMA_DRC_RR_INDEX]);

            sampleBuffer[destIndex + DRC_RL_INDEX]  = rl;
            sampleBuffer[destIndex + DRC_RR_INDEX]  = rr;
        }
    }

    return samples;
}

#ifdef NW_SND_CONFIG_ENABLE_APPFRAMECALLBACK
//---------------------------------------------------------------------------
void
DrcWavOutRecorder::AxAppFrameCallbackFunc()
{
    const u32 maxSamplesPerFrame = MAX_CHANNELS * SAMPLES_PER_SEC * 3 / 1000;
    s16 finalOutput[maxSamplesPerFrame];

    AXDEVICEFINALOUTPUTSTRUCT finalInfo;
    AXPB_ERROR_CODE error = AXGetDeviceFinalOutput(AX_DEVICE_DRC, finalOutput, maxSamplesPerFrame * BYTES_PER_SAMPLE, &finalInfo);
    //NW_ASSERT(finalInfo.numDevices == 1 || finalInfo.numDevices == 2); // TODO:DRC 2台対応
    NW_ASSERT(finalInfo.sampFreq == AI_SAMPLERATE_48KHZ);
    NW_ASSERT(error == AXPB_ERROR_NONE);

    NW_NULL_ASSERT(s_pThis);
    s_pThis->PushSamples(finalOutput, finalInfo.length / sizeof(s16));
}
#endif

} // snd
} // nw
