﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "fnd/basis/sndfnd_Memory.cpp"
#include "fnd/io/sndfnd_Stream.cpp"
#include "fnd/io/sndfnd_FileStreamImpl.cpp"
#include "fnd/io/sndfnd_HioFileStreamImpl.cpp"
#include "fnd/io/sndfnd_StreamCache.cpp"
#include "fnd/io/sndfnd_AiffStream.cpp"
#include "fnd/io/sndfnd_WavStream.cpp"
#include "fnd/io/sndfnd_SimpleRingBuffer.cpp"
#include "fnd/io/sndfnd_HioStream.cpp"
#include "fnd/os/sndfnd_Thread.cpp"
#include "fnd/string/sndfnd_String.cpp"
#include "fnd/string/sndfnd_FixedString.cpp"

#include <nw/config.h>

#if defined( NW_PLATFORM_CAFE )

    #include "fnd/basis/Cafe/sndfnd_TimeCafe.cpp"
    #include "fnd/io/Cafe/sndfnd_FileCafe.cpp"
    #include "fnd/io/Cafe/sndfnd_FileStreamImplCafe.cpp"
    #include "fnd/io/Cafe/sndfnd_HioStreamCafe.cpp"
    #include "fnd/os/Cafe/sndfnd_ThreadCafe.cpp"
    #include "fnd/string/Cafe/sndfnd_PathCafe.cpp"

#elif defined(NW_PLATFORM_ANDROID)

    #include "fnd/io/Android/sndfnd_HioStreamAndroid.cpp"
    #include "fnd/basis/Android/sndfnd_TimeAndroid.cpp"
    #include "fnd/io/Android/sndfnd_FileAndroid.cpp"
    #include "fnd/io/Android/sndfnd_FileStreamImplAndroid.cpp"
    #include "fnd/os/Android/sndfnd_ThreadAndroid.cpp"
    #include "fnd/string/Android/sndfnd_PathAndroid.cpp"

#elif defined( NW_PLATFORM_WIN32 )

    #include "fnd/io/Win/sndfnd_HioStreamWin.cpp"
        // WinSock2.h を先にインクルードする必要があるので、
        // WinSock2.h をインクルードしているこの cpp を一番最初にインクルードする
    #include "fnd/basis/Win/sndfnd_TimeWin.cpp"
    #include "fnd/io/Win/sndfnd_FileWin.cpp"
    #include "fnd/io/Win/sndfnd_FileStreamImplWin.cpp"
    #include "fnd/os/Win/sndfnd_ThreadWin.cpp"
    #include "fnd/string/Win/sndfnd_PathWin.cpp"

#elif defined( NW_USE_NINTENDO_SDK )

    #include "fnd/io/NNSDK/sndfnd_HioStreamNNSDK.cpp"
        // WinSock2.h を先にインクルードする必要があるので、
        // WinSock2.h をインクルードしているこの cpp を一番最初にインクルードする
    #include "fnd/basis/NNSDK/sndfnd_TimeNNSDK.cpp"
    #include "fnd/io/NNSDK/sndfnd_FileNNSDK.cpp"
    #include "fnd/io/NNSDK/sndfnd_FileStreamImplNNSDK.cpp"
    #include "fnd/os/NNSDK/sndfnd_ThreadNNSDK.cpp"
    #include "fnd/string/NNSDK/sndfnd_PathNNSDK.cpp"

#endif
