﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/fnd/string/sndfnd_String.h>
#include <nw/snd/fnd/string/sndfnd_FixedString.h>

#if defined( NW_PLATFORM_CTR )
#ifndef NW_ASSERT_NOT_NULL
#define NW_ASSERT_NOT_NULL NW_NULL_ASSERT
#endif
#endif

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

//----------------------------------------------------------
FixedString::FixedString() :
m_Buffer(NULL),
m_BufferLength(0)
{
}

//----------------------------------------------------------
FixedString::FixedString(char* buffer, u32 bufferLength) :
m_Buffer(buffer),
m_BufferLength(bufferLength)
{
    NW_ASSERT((buffer == NULL) == (bufferLength == 0));
}

//----------------------------------------------------------
void
FixedString::Attach(char* buffer, u32 bufferLength)
{
    NW_ASSERT_NOT_NULL(buffer);
    NW_ASSERT(bufferLength > 0);
    NW_ASSERTMSG(!IsAttached(), "FixedString is already attached.\n");

    m_BufferLength = bufferLength;
    m_Buffer = buffer;

    // 終端文字を設定します。
    m_Buffer[m_BufferLength - 1] = '\0';
}

//----------------------------------------------------------
void
FixedString::Detach()
{
    m_BufferLength = 0;
    m_Buffer = NULL;
}

//----------------------------------------------------------
void
FixedString::CopyFrom(const char* value, u32 length, u32 index/*= 0*/)
{
    CopyPartFrom(value, length, index);

    // 終端文字を設定します。
    NW_ASSERTMSG(index + length <= m_BufferLength, "buffer over flow.\n");
    m_Buffer[index + length] = '\0';
}

//----------------------------------------------------------
void
FixedString::CopyPartFrom(const char* value, u32 length, u32 index/*= 0*/)
{
    NW_ASSERTMSG(m_Buffer != NULL, "buffer is not attached.\n");
    NW_ASSERT_NOT_NULL(value);
    NW_ASSERTMSG(index + length < m_BufferLength, "buffer over flow.\n");

    String::Copy(m_Buffer + index, m_BufferLength - index, value, length);
}

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw
