﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/fnd/os/sndfnd_Thread.h>

#include <unistd.h>
#include <pthread.h>

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

#if 0
namespace {

//---------------------------------------------------------------------------
//! @brief  Win32 スレッドのプライオリティに変換します。
s32 ToWin32Priority(u32 value)
{
    static const u32 Range      = Thread::MAX_THREAD_PRIORITY - Thread::MIN_THREAD_PRIORITY + 1;
    static const u32 RangeWin32 = THREAD_PRIORITY_HIGHEST - THREAD_PRIORITY_LOWEST + 1;
    return THREAD_PRIORITY_LOWEST + (value * RangeWin32 / Range);
}

}
#endif

//---------------------------------------------------------------------------
//! @brief  スレッドのメイン関数オブジェクトです。
//---------------------------------------------------------------------------
class Thread::ThreadMain
{
public:
    static void* Run(void* param)
    {
        Thread* owner = reinterpret_cast<Thread*>(param);

        NW_ASSERT_NOT_NULL(owner);
        NW_ASSERT_NOT_NULL(owner->m_Handler);

        owner->OnRun();

        u32 result = owner->m_Handler->Run(owner->m_Param);

        owner->OnExit();

        return (void*)result;
    }
};

//---------------------------------------------------------------------------
Thread::Thread() :
m_State(STATE_NOT_RUN),
m_ID(INVALID_ID),
m_Priority(DEFAULT_THREAD_PRIORITY),
m_Name(""),
m_Handler(NULL)
{
}

//---------------------------------------------------------------------------
void
Thread::SetPriority(s32 value)
{
#if 0
    if(value == 16)
    {
        ::SetThreadPriority(m_Handle, THREAD_PRIORITY_NORMAL);
        return;
    }

    if(value == 0)
    {
        ::SetThreadPriority(m_Handle, THREAD_PRIORITY_IDLE);
        return;
    }

    if(value < 8)
    {
        ::SetThreadPriority(m_Handle, THREAD_PRIORITY_LOWEST);
        return;
    }

    if(value < 16)
    {
        ::SetThreadPriority(m_Handle, THREAD_PRIORITY_BELOW_NORMAL);
        return;
    }

    if(value < 24)
    {
        ::SetThreadPriority(m_Handle, THREAD_PRIORITY_ABOVE_NORMAL);
        return;
    }

    if(value < 31)
    {
        ::SetThreadPriority(m_Handle, THREAD_PRIORITY_HIGHEST);
        return;
    }

    ::SetThreadPriority(m_Handle, THREAD_PRIORITY_NORMAL);
#endif
    // TODO: Unimplemented
    int result = 0;
    const int niceMin = -20;
    const int niceMax = 19;
    int niceValue = 0;

    if (value == 16) niceValue = 0;
    else if (value == 0) niceValue = niceMax;
    else if (value ) niceValue = niceMax;
}

//---------------------------------------------------------------------------
void
Thread::Sleep(const TimeSpan& timeSpan)
{
    ::usleep(timeSpan.ToMilliSeconds() * 1000);
}

//---------------------------------------------------------------------------
bool
Thread::Create(Handle& handle, u32& id, const RunArgs& args)
{
    int ret = pthread_create(&handle, NULL, ThreadMain::Run, this);

    if(ret < 0)
    {
        id = INVALID_ID;
        return false;
    }

    NW_ASSERT(id != INVALID_ID);

//    SetThreadPriority(handle, ToWin32Priority(args.priority));

    return true;
}

//---------------------------------------------------------------------------
void
Thread::Detach()
{
    if ( m_Handle != NULL )
    {
        pthread_detach(m_Handle);
        m_Handle = NULL;
    }
}

//---------------------------------------------------------------------------
void
Thread::SetName(const char* name )
{
    int ret = pthread_setname_np(pthread_self(), name);
    NW_ASSERT(ret >= 0);
}

//---------------------------------------------------------------------------
void
Thread::SetAffinityMask(AFFINITY_MASK value)
{
    // TODO: Unimplemented
    // ::SetThreadAffinityMask(m_Handle, value);
}

//---------------------------------------------------------------------------
void
Thread::Resume()
{
    // TODO: Unimplemented
#if 0
    ::ResumeThread(m_Handle);
#endif
}

//---------------------------------------------------------------------------
void
Thread::Join()
{
    int ret = pthread_join(m_Handle, NULL);

    NW_ASSERT(ret >= 0);
}

//---------------------------------------------------------------------------
bool
Thread::IsTerminated() const
{
    // TODO: Unimplemented
#if 0
    if(m_Handle == NULL)
    {
        return true;
    }

    return ::WaitForSingleObject(m_Handle, 0) == WAIT_OBJECT_0;
#endif
}

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw
