﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/fnd/io/sndfnd_File.h>

#include <nw/snd/fnd/io/sndfnd_FileStream.h>

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

namespace {

//---------------------------------------------------------------------------
nn::fs::OpenMode
ConvertAccessMode(File::AccessMode accessMode)
{
    switch(accessMode)
    {
    case File::ACCESS_MODE_READ:
        return nn::fs::OpenMode_Read;

    case File::ACCESS_MODE_WRITE:
        return nn::fs::OpenMode_Write;

    case File::ACCESS_MODE_READ | File::ACCESS_MODE_WRITE:
        return nn::fs::OpenMode_AllowAppend;

    default:
        break;
    }

    return nn::fs::OpenMode_Read;
}

}

//---------------------------------------------------------------------------
FndResult
File::Open(
    FileStream* stream,
    const char* filePath,
    AccessMode accessMode)
{
    NW_ASSERT_NOT_NULL(stream);

    nn::fs::OpenMode desiredAccess = ConvertAccessMode(accessMode);
    NW_ASSERT_NOT_NULL(desiredAccess);

    nn::Result result = stream->Open(filePath, desiredAccess);

    if(result.IsFailure())
    {
        if (nn::fs::ResultPathNotFound::Includes(result))
        {
            return FndResult(SNDFND_RESULT_IO_FILE_NOT_FOUND);
        }
        else if (nn::fs::ResultDataCorrupted::Includes(result))
        {
            return FndResult(SNDFND_RESULT_IO_INVALID_ACCESS);
        }

        return FndResult(SNDFND_RESULT_IO_ERROR);
    }

    return FndResult(SNDFND_RESULT_TRUE);
}

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw
