﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/fnd/io/sndfnd_File.h>

#include <nw/snd/fnd/io/sndfnd_FileStream.h>

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

namespace {

//---------------------------------------------------------------------------
const char*
ConvertAccessMode(File::AccessMode accessMode)
{
    switch(accessMode)
    {
    case File::ACCESS_MODE_READ:
        return "r";

    case File::ACCESS_MODE_WRITE:
        return "w+";

    case File::ACCESS_MODE_READ | File::ACCESS_MODE_WRITE:
        return "r+";

    default:
        break;
    }

    return NULL;
}

}

//---------------------------------------------------------------------------
FndResult
File::Open(
    FileStream* stream,
    FSClient* fsClient,
    FSCmdBlock* fsCmdBlock,
    const char* filePath,
    AccessMode accessMode)
{
    NW_ASSERT_NOT_NULL(stream);

    const char* desiredAccess = ConvertAccessMode(accessMode);
    NW_ASSERT_NOT_NULL(desiredAccess);

    FSFileHandle fileHandle = FS_INVALID_HANDLE_VALUE;
    FSStatus result = FSOpenFile(fsClient, fsCmdBlock, filePath, desiredAccess, &fileHandle, FS_RET_ALL_ERROR);

    if(result < 0)
    {
        switch(result)
        {
        case FS_STATUS_NOT_FOUND:
        case FS_STATUS_NOT_FILE:
            return FndResult(SNDFND_RESULT_IO_FILE_NOT_FOUND);

        case FS_STATUS_ACCESS_ERROR:
        case FS_STATUS_PERMISSION_ERROR:
            return FndResult(SNDFND_RESULT_IO_INVALID_ACCESS);
        }

        return FndResult(SNDFND_RESULT_IO_ERROR);
    }

    stream->Open(fsClient, fsCmdBlock, fileHandle);
    return FndResult(SNDFND_RESULT_TRUE);
}

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw
