﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/fnd/io/sndfnd_File.h>
#include <nw/snd/fnd/io/sndfnd_FileStream.h>

#include <cstdio>
#include <cerrno>

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

namespace {

//---------------------------------------------------------------------------
const char*
ConvertAccessMode(File::AccessMode accessMode)
{
    switch(accessMode)
    {
    case File::ACCESS_MODE_READ:
        return "rb";

    case File::ACCESS_MODE_WRITE:
        return "wb";

    case File::ACCESS_MODE_READ_AND_WRITE:
        return "w+b";
    default:
        break;
    }

    return NULL;
}

}

//---------------------------------------------------------------------------
FndResult
File::Open(FileStream* stream, const char* filePath, AccessMode accessMode)
{
    NW_ASSERT_NOT_NULL(stream);

    const char* desiredAccess = ConvertAccessMode(accessMode);
    NW_ASSERT(desiredAccess > 0);

    FILE *handle = fopen(filePath, desiredAccess);

    if(handle == NULL)
    {
        switch(errno)
        {
        case ENOENT:
            return FndResult(SNDFND_RESULT_IO_FILE_NOT_FOUND);
        }
        return FndResult(SNDFND_RESULT_FAILED);
    }

    stream->Open(reinterpret_cast<void*>(handle));
    return FndResult(SNDFND_RESULT_TRUE);
}

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw
